<?php

namespace App\Http\Controllers;

use App\Models\CostCategory;
use Illuminate\Http\Request;

class CostCategoryController extends Controller
{
    public function index()
    {
        $categories = CostCategory::paginate(20);
        return view('admin.cost-categories.index', compact('categories'));
    }

    public function create()
    {
        return view('admin.cost-categories.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|unique:cost_categories|max:100',
            'is_government_covered' => 'boolean',
            'is_taxable' => 'boolean',
        ]);

        CostCategory::create($validated);

        return redirect()->route('admin.cost-categories.index')
            ->with('success', 'Cost category created successfully');
    }

    public function edit(CostCategory $costCategory)
    {
        return view('admin.cost-categories.edit', compact('costCategory'));
    }

    public function update(Request $request, CostCategory $costCategory)
    {
        $validated = $request->validate([
            'name' => 'required|max:100|unique:cost_categories,name,'.$costCategory->id,
            'is_government_covered' => 'boolean',
            'is_taxable' => 'boolean',
        ]);

        $costCategory->update($validated);

        return redirect()->route('admin.cost-categories.index')
            ->with('success', 'Cost category updated successfully');
    }

    public function destroy(CostCategory $costCategory)
    {
        $costCategory->delete();
        return redirect()->route('admin.cost-categories.index')
            ->with('success', 'Cost category deleted successfully');
    }
}