<?php

namespace App\Http\Controllers;

use App\Models\PaymentInstallment;
use App\Models\Payment;
use Illuminate\Http\Request;

class PaymentInstallmentController extends Controller
{
    public function index()
    {
        $installments = PaymentInstallment::with(['plan.allocation.student'])
            ->where('status', 'pending')
            ->paginate(25);
            
        return view('admin.payment-installments.index', compact('installments'));
    }

    public function show(PaymentInstallment $paymentInstallment)
    {
        return view('admin.payment-installments.show', compact('paymentInstallment'));
    }

    public function processPayment(PaymentInstallment $installment)
    {
        // Create payment record
        $payment = Payment::create([
            'student_id' => $installment->plan->allocation->student_id,
            'allocation_id' => $installment->plan->allocation_id,
            'installment_id' => $installment->plan_id,
            'amount' => $installment->amount,
            'status' => 'pending',
            'source' => 'student',
        ]);

        // Mark installment as processing
        $installment->update(['status' => 'processing']);

        return redirect()->route('admin.payments.show', $payment)
            ->with('info', 'Now process the payment for this installment');
    }

    public function markPaid(PaymentInstallment $installment)
    {
        $installment->update([
            'status' => 'paid',
            'paid_date' => now(),
        ]);

        return back()->with('success', 'Installment marked as paid');
    }
}