<?php

namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use App\Models\Policy;
use Carbon\Carbon;
use Illuminate\Http\Request;

class PolicyController extends Controller
{
    //

public function getByCustomer($customerId)
{
    $policies = Policy::where('customer_id', $customerId)
        ->select('id', 'policy_number')
        ->orderBy('policy_number')
        ->get();

    $results = $policies->map(function ($policy) {
        return [
            'id' => $policy->id,
            'text' => $policy->policy_number,
        ];
    });

    return response()->json(['results' => $results]);
}

public function details($id)
{
    $policy = Policy::find($id);

    if (!$policy) {
        return response()->json(['error' => 'Policy not found'], 404);
    }

    return response()->json([
        'status' => ucfirst($policy->status),
        'policy_name' => $policy->policy_name,
        'description' => $policy->description,
        'start_date' => $policy->start_date ? Carbon::parse($policy->start_date)->format('Y-m-d') : null,
        'end_date' => $policy->end_date ? Carbon::parse($policy->end_date)->format('Y-m-d') : null,
        'premium_amount' => $policy->premium_amount,
    ]);
}

public function show($id)
{
    $policy = \App\Models\Policy::find($id);

    if (!$policy) {
        return response()->json(['message' => 'Policy not found'], 404);
    }

    return response()->json([
        'id' => $policy->id,
        'policy_number' => $policy->policy_number,
        'policy_type' => $policy->policy_type,
        'coverage_type' => $policy->coverage_type,
        'start_date' => $policy->start_date,
        'end_date' => $policy->end_date,
        'premium_amount' => $policy->premium_amount,
        'status' => $policy->status,
        // add any other fields needed for the view
    ]);
}

}
