<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;

class SettingController extends Controller
{
    public function paymentGateways()
    {
        $settings = Setting::where('group', 'payment_gateways')->get();
        return view('admin.settings.payment-gateways', compact('settings'));
    }

    public function telebirr()
    {
        $settings = Setting::where('group', 'telebirr')->get();
        return view('admin.settings.telebirr', compact('settings'));
    }

    public function updateTelebirr(Request $request)
    {
        $validated = $request->validate([
            'app_id' => 'required|string',
            'app_key' => 'required|string',
            'api_url' => 'required|url',
        ]);

        foreach($validated as $key => $value) {
            Setting::updateOrCreate(
                ['key' => $key, 'group' => 'telebirr'],
                ['value' => $value]
            );
        }

        return back()->with('success', 'Telebirr settings updated');
    }

    public function revenueApi()
    {
        $settings = Setting::where('group', 'revenue_api')->get();
        return view('admin.settings.revenue-api', compact('settings'));
    }

    public function updateRevenueApi(Request $request)
    {
        $validated = $request->validate([
            'api_url' => 'required|url',
            'api_key' => 'required|string',
            'tax_rate' => 'required|numeric|min:0|max:100',
        ]);

        foreach($validated as $key => $value) {
            Setting::updateOrCreate(
                ['key' => $key, 'group' => 'revenue_api'],
                ['value' => $value]
            );
        }

        return back()->with('success', 'Revenue API settings updated');
    }

    // Other setting sections...
}