<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\TaxExemption;
use Illuminate\Http\Request;

class TaxExemptionController extends Controller
{
    public function index()
    {
        $exemptions = TaxExemption::with('student')
            ->paginate(25);
            
        return view('admin.tax-exemptions.index', compact('exemptions'));
    }

    public function create()
    {
        $students = Student::whereDoesntHave('taxExemption')->get();
        return view('admin.tax-exemptions.create', compact('students'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'student_id' => 'required|exists:students,id|unique:tax_exemptions',
            'exemption_certificate_number' => 'required|unique:tax_exemptions|max:50',
            'valid_from' => 'required|date',
            'valid_to' => 'required|date|after:valid_from',
            'reason' => 'required|max:255',
        ]);

        TaxExemption::create($validated);

        // Update student tax status
        Student::find($validated['student_id'])
            ->update(['is_tax_exempt' => true]);

        return redirect()->route('admin.tax-exemptions.index')
            ->with('success', 'Tax exemption created successfully');
    }

    public function certificates()
    {
        $certificates = TaxExemption::where('valid_to', '>=', now())
            ->paginate(25);
            
        return view('admin.tax-exemptions.certificates', compact('certificates'));
    }

    public function reports()
    {
        // Tax reports logic
    }
}