<?php

namespace App\Http\Controllers;

use App\Models\CostCategory;
use App\Models\UniversityCost;
use Illuminate\Http\Request;

class UniversityCostController extends Controller
{
    public function index()
    {
        $costs = UniversityCost::with('category')->paginate(25);
        return view('admin.university-costs.index', compact('costs'));
    }

    public function create()
    {
        $categories = CostCategory::all();
        return view('admin.university-costs.create', compact('categories'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'category_id' => 'required|exists:cost_categories,id',
            'academic_year' => 'required|max:9|regex:/^\d{4}\/\d{4}$/',
            'amount' => 'required|numeric|min:0',
            'frequency' => 'required|in:semester,annual,one-time',
        ]);

        UniversityCost::create($validated);

        return redirect()->route('admin.university-costs.index')
            ->with('success', 'University cost created successfully');
    }

    public function edit(UniversityCost $universityCost)
    {
        $categories = CostCategory::all();
        return view('admin.university-costs.edit', compact('universityCost', 'categories'));
    }

    public function update(Request $request, UniversityCost $universityCost)
    {
        $validated = $request->validate([
            'category_id' => 'required|exists:cost_categories,id',
            'academic_year' => 'required|max:9|regex:/^\d{4}\/\d{4}$/',
            'amount' => 'required|numeric|min:0',
            'frequency' => 'required|in:semester,annual,one-time',
        ]);

        $universityCost->update($validated);

        return redirect()->route('admin.university-costs.index')
            ->with('success', 'University cost updated successfully');
    }

    public function destroy(UniversityCost $universityCost)
    {
        $universityCost->delete();
        return redirect()->route('admin.university-costs.index')
            ->with('success', 'University cost deleted successfully');
    }
}