<?php

use Illuminate\Http\Request;
use App\Models\Student;
use Illuminate\Support\Facades\Http;

class TelebirrAuthController extends Controller
{
    public function login(Request $request)
    {
        $code = $request->input('code'); // Code sent from Telebirr Mini App

        // Exchange code for openId
        $response = Http::post('https://openapi.telebirr.et/miniprogram/userinfo', [
            'appId' => config('telebirr.app_id'),
            'secret' => config('telebirr.secret'),
            'js_code' => $code,
            'grant_type' => 'authorization_code',
        ]);

        if ($response->failed()) {
            return response()->json(['message' => 'Telebirr login failed.'], 401);
        }

        $data = $response->json();

        $openId = $data['openId'] ?? null;

        if (!$openId) {
            return response()->json(['message' => 'Invalid response from Telebirr.'], 401);
        }

        // Check if student already exists
        $student = Student::where('telebirr_open_id', $openId)->first();

        if (!$student) {
            // Optionally: auto-create student or reject
            return response()->json(['message' => 'Student not found.'], 404);
        }

        // Log in or issue token (JWT, Sanctum, etc.)
        $token = $student->createToken('telebirr_token')->plainTextToken;

        return response()->json([
            'message' => 'Login successful.',
            'student' => $student,
            'token' => $token,
        ]);
    }
}
