<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'first_name', 'middle_name', 'last_name', 'gender', 'date_of_birth', 'place_of_birth',
        'marital_status', 'nationality', 'national_id', 'passport_number', 'tax_id', 'email', 'phone',
        'alt_phone', 'address', 'house_number', 'city', 'state', 'country', 'administrative_region_city',
        'sub_city_zone', 'wereda_town', 'kebele', 'postal_code', 'occupation', 'employer_name',
        'employer_address', 'employment_status', 'annual_income', 'customer_status', 'notes', 'source',
        'password', 'preferred_contact_method', 'allow_marketing_emails', 'allow_sms_notifications',
        'allow_push_notifications', 'language_preference', 'timezone'
    ];

    protected $hidden = ['password'];

    public function getNameAttribute()
    {
        return "{$this->first_name} {$this->last_name}";
    }
}


