<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class InstallmentPlan extends Model
{
    use HasFactory;

    protected $fillable = [
        'allocation_id',
        'total_installments',
        'installment_amount',
        'start_date',
        'interval',
        'is_active'
    ];

    protected $casts = [
        'start_date' => 'date',
        'is_active' => 'boolean'
    ];

    public function allocation()
    {
        return $this->belongsTo(StudentCostAllocation::class);
    }

    public function installments()
    {
        return $this->hasMany(PaymentInstallment::class, 'plan_id');
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
}