<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Payment extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id',
        'allocation_id',
        'installment_id',
        'amount',
        'telebirr_transaction_id',
        'revenue_receipt_id',
        'status',
        'source',
        'tax_details',
        'paid_at'
    ];

    protected $casts = [
        'paid_at' => 'datetime',
        'tax_details' => 'array'
    ];

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function allocation()
    {
        return $this->belongsTo(StudentCostAllocation::class);
    }

    public function installmentPlan()
    {
        return $this->belongsTo(InstallmentPlan::class, 'installment_id');
    }

    public function installments()
    {
        return $this->hasMany(PaymentInstallment::class);
    }
}