<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PaymentInstallment extends Model
{
    use HasFactory;

    protected $fillable = [
        'payment_id',
        'plan_id',
        'amount',
        'due_date',
        'paid_date',
        'status'
    ];

    protected $casts = [
        'due_date' => 'date',
        'paid_date' => 'date'
    ];

    public function payment()
    {
        return $this->belongsTo(Payment::class);
    }

    public function plan()
    {
        return $this->belongsTo(InstallmentPlan::class);
    }
}