<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Student extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $fillable = [
        'student_id',
        'tin_number',
        'full_name',
        'email',
        'phone',
        'password',
        'is_tax_exempt'
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    public function profile()
    {
        return $this->hasOne(UniversityProfile::class);
    }

    public function allocations()
    {
        return $this->hasMany(StudentCostAllocation::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function taxExemption()
    {
        return $this->hasOne(TaxExemption::class);
    }
}