<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StudentCostAllocation extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id',
        'cost_id',
        'student_share',
        'government_share',
        'academic_year'
    ];

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function cost()
    {
        return $this->belongsTo(UniversityCost::class, 'cost_id');
    }

    public function installments()
    {
        return $this->hasOne(InstallmentPlan::class, 'allocation_id');
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function governmentContributions()
    {
        return $this->hasMany(GovernmentContribution::class);
    }
}