<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TaxExemption extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id',
        'exemption_certificate_number',
        'valid_from',
        'valid_to',
        'reason',
        'status'
    ];

    protected $casts = [
        'valid_from' => 'date',
        'valid_to' => 'date'
    ];

    public function student()
    {
        return $this->belongsTo(Student::class);
    }
}