<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UniversityCost extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'academic_year',
        'amount',
        'frequency'
    ];

    public function category()
    {
        return $this->belongsTo(CostCategory::class);
    }

    public function allocations()
    {
        return $this->hasMany(StudentCostAllocation::class);
    }
}