<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Student;

class UniversityProfile extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id',
        'faculty',
        'department',
        'program',
        'enrollment_year',
        'expected_graduation',
        'study_level'
    ];

    public function student()
    {
        return $this->belongsTo(Student::class);
    }
}
