<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'key',
        'value',
        'group'
    ];

    protected $casts = [
        'value' => 'array'
    ];

    // Helper method to get settings by group
    public static function getByGroup($group)
    {
        return static::where('group', $group)->get()->mapWithKeys(function ($item) {
            return [$item->key => $item->value];
        });
    }
}