<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    protected $table = 'students';

    protected $fillable = [
        'telebirr_open_id',
        'tin_number',
        'student_id',
        'university_id',
        'full_name',
        'gender',
        'birth_date',
        'phone',
        'email',
    ];

    protected $casts = [
        'birth_date' => 'date',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Example relationship to University (if you have a `universities` table)
    public function university()
    {
        return $this->belongsTo(University::class);
    }

    // Example relationship to Payments
    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
}
