<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class RevenueService
{
    protected $apiKey;
    protected $apiUrl;
    protected $taxRate;
    
    public function __construct()
    {
        $this->apiKey = config('services.revenue.api_key');
        $this->apiUrl = config('services.revenue.api_url');
        $this->taxRate = config('services.revenue.tax_rate', 15);
    }



    public function reportPayment(array $paymentData)
    {
        try {
            $payload = [
                'taxpayer_id' => $paymentData['student_id'],
                'amount' => $paymentData['amount'],
                'payment_reference' => $paymentData['telebirr_id'],
                'payment_date' => now()->toIso8601String(),
                'tax_rate' => $this->taxRate,
                'tax_amount' => $paymentData['amount'] * ($this->taxRate / 100),
            ];

            $response = Http::withHeaders([
                'X-API-KEY' => $this->apiKey,
                'Content-Type' => 'application/json'
            ])->post($this->apiUrl . '/transactions', $payload);

            if ($response->successful()) {
                return $response->json()['receipt_id'] ?? null;
            }

            Log::error('Revenue reporting failed: ' . $response->body());
            return null;

        } catch (\Exception $e) {
            Log::error('Revenue service error: ' . $e->getMessage());
            return null;
        }
    }

        public function getReceiptId($transactionId)
    {
        // Your logic here
        return 'RECEIPT-' . $transactionId;
    }
}