<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class TelebirrService
{
    protected $appId;
    protected $appKey;
    protected $apiUrl;
    
    public function __construct()
    {
        $this->appId = config('services.telebirr.app_id');
        $this->appKey = config('services.telebirr.app_key');
        $this->apiUrl = config('services.telebirr.api_url');
    }

    public function initiatePayment(array $data)
    {
        try {
            $payload = [
                'appId' => $this->appId,
                'appKey' => $this->appKey,
                'amount' => $data['amount'],
                'reference' => $data['reference'],
                'customerPhone' => $data['phone'],
                'returnUrl' => route('payment.callback'),
                'notifyUrl' => route('payment.webhook'),
                'subject' => 'University Payment',
                'timeoutExpress' => '30',
            ];

            $response = Http::withHeaders([
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
            ])->post($this->apiUrl . '/initiate', $payload);

            return $response->json();

        } catch (\Exception $e) {
            Log::error('Telebirr initiation failed: ' . $e->getMessage());
            return ['status' => 'error', 'message' => $e->getMessage()];
        }
    }

    public function verifyPayment(string $transactionId)
    {
        try {
            $response = Http::withHeaders([
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer ' . $this->appKey,
            ])->post($this->apiUrl . '/verify', [
                'transactionId' => $transactionId
            ]);

            $data = $response->json();

            if ($response->successful() && $data['code'] == 200) {
                return 'SUCCESS';
            }

            return 'FAILED';

        } catch (\Exception $e) {
            Log::error('Telebirr verification failed: ' . $e->getMessage());
            return 'FAILED';
        }
    }
    
    public function checkPaymentStatus(string $reference)
    {
        try {
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $this->appKey,
            ])->get($this->apiUrl . '/status', [
                'reference' => $reference
            ]);

            return $response->json();
            
        } catch (\Exception $e) {
            Log::error('Telebirr status check failed: ' . $e->getMessage());
            return ['status' => 'error'];
        }
    }
}