<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
    Schema::create('revenue_transactions', function (Blueprint $table) {
    $table->id();
    $table->string('reference_number')->unique();
    $table->foreignId('payment_id')->constrained()->onDelete('cascade');
    $table->string('status')->default('pending');
    $table->json('response_payload')->nullable();
    $table->dateTime('processed_at')->nullable();
    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('revenue_transactions');
    }
};
