<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentPaymentIndexTable extends Migration
{
    public function up(): void
    {
        Schema::create('student_payment_index', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('student_id');
            $table->string('student_unique_id')->nullable(); // internal ID
            $table->string('tin_number')->nullable();

            $table->string('first_name')->nullable();
            $table->string('middle_name')->nullable();
            $table->string('last_name')->nullable();

            $table->year('graduation_year')->nullable();
            $table->unsignedBigInteger('university_id')->nullable();
            $table->string('university_name')->nullable();

            $table->decimal('total_paid', 12, 2)->default(0);
            $table->unsignedInteger('payment_count')->default(0);
            $table->timestamp('last_payment_at')->nullable();

            $table->timestamps();

            // Indexes for search performance
            $table->index('student_id');
            $table->index('student_unique_id');
            $table->index('tin_number');
            $table->index(['first_name', 'middle_name', 'last_name']);
            $table->index('graduation_year');
            $table->index('university_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('student_payment_index');
    }
}
