<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


class ModifyStudentIdColumnOnPaymentsTable extends Migration
{
    public function up()
    {
        Schema::table('payments', function (Blueprint $table) {
            // Drop the foreign key constraint
            $table->dropForeign(['student_id']);
        });
    }

    public function down()
    {
        Schema::table('payments', function (Blueprint $table) {
            // Re-add foreign key if reverting
            $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
        });
    }
}
