<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

// database/migrations/[timestamp]_create_university_profiles_table.php
return new class extends Migration {
    public function up()
    {
        Schema::create('university_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained()->cascadeOnDelete();
            $table->string('faculty');
            $table->string('department');
            $table->string('program');
            $table->year('enrollment_year');
            $table->year('expected_graduation');
            $table->enum('study_level', ['undergraduate', 'masters', 'phd']);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('university_profiles');
    }
};