<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

// database/migrations/[timestamp]_create_university_costs_table.php
return new class extends Migration {
    public function up()
    {
        Schema::create('university_costs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained('cost_categories');
            $table->string('academic_year');
            $table->decimal('amount', 10, 2);
            $table->enum('frequency', ['semester', 'annual', 'one-time']);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('university_costs');
    }
};