<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

// database/migrations/[timestamp]_create_student_cost_allocations_table.php
return new class extends Migration {
    public function up()
    {
        Schema::create('student_cost_allocations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained()->cascadeOnDelete();
            $table->foreignId('cost_id')->constrained('university_costs');
            $table->decimal('student_share', 10, 2);
            $table->decimal('government_share', 10, 2)->default(0);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('student_cost_allocations');
    }
};