<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

// database/migrations/[timestamp]_create_installment_plans_table.php
return new class extends Migration {
    public function up()
    {
        Schema::create('installment_plans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('allocation_id')->constrained('student_cost_allocations');
            $table->tinyInteger('total_installments');
            $table->decimal('installment_amount', 10, 2);
            $table->date('start_date');
            $table->enum('interval', ['monthly', 'quarterly', 'semester']);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('installment_plans');
    }
};