<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

// database/migrations/[timestamp]_create_government_contributions_table.php
return new class extends Migration {
    public function up()
    {
        Schema::create('government_contributions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('allocation_id')->constrained('student_cost_allocations');
            $table->decimal('amount', 10, 2);
            $table->string('disbursement_ref');
            $table->date('disbursement_date');
            $table->enum('status', ['approved', 'pending', 'rejected']);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('government_contributions');
    }
};