<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

// database/migrations/[timestamp]_create_payment_audits_table.php
return new class extends Migration {
    public function up()
    {
        Schema::create('payment_audits', function (Blueprint $table) {
            $table->id();
            $table->foreignUuid('payment_id')->constrained('payments');
            $table->string('action');
            $table->json('old_values')->nullable();
            $table->json('new_values')->nullable();
            $table->string('ip_address');
            $table->timestamp('performed_at');
        });
    }

    public function down()
    {
        Schema::dropIfExists('payment_audits');
    }
};
