<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('permissions', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id'); // bigint(20) UNSIGNED NOT NULL
            
            // Permission Details
            $table->string('name', 100)->unique(); // varchar(100) NOT NULL
            $table->string('description', 255)->nullable(); // varchar(255) DEFAULT NULL
            
            // Timestamps
            $table->timestamp('created_at')->useCurrent(); // DEFAULT CURRENT_TIMESTAMP
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate(); // ON UPDATE CURRENT_TIMESTAMP
        });

        // Explicitly set engine and collation
        Schema::table('permissions', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('permissions');
    }
};