<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('audit_logs', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id');

            // Foreign Key
            $table->foreignId('user_id')
                ->constrained()
                ->onDelete('cascade');

            // Audit Details
            $table->enum('action', [
                'insert',
                'update',
                'delete',
                'login'
            ]);

            $table->string('table_name', 255);
            $table->bigInteger('record_id'); // Signed bigint to match SQL
            
            // JSON Data (MySQL 5.7+ compatible)
            $table->json('changed_data')
                ->nullable()
                ->comment('Stores JSON changes');

            // IP Tracking
            $table->string('ip_address', 45)
                ->nullable();

            // Timestamp
            $table->timestamp('created_at')
                ->nullable()
                ->useCurrent();
        });

        // Explicit database configuration
        Schema::table('audit_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
            
            // Add JSON validation constraint (MySQL specific)
            DB::statement('ALTER TABLE audit_logs 
                ADD CONSTRAINT audit_logs_changed_data_check 
                CHECK (json_valid(changed_data))');
        });
    }

    public function down()
    {
        Schema::dropIfExists('audit_logs');
    }
};