<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('error_logs', function (Blueprint $table) {
            // Primary Key (int(11) NOT NULL)
            $table->increments('id'); // Creates `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY
            
            // Error Classification
            $table->enum('error_type', [
                'database',
                'application',
                'server'
            ]);

            // Error Details
            $table->text('error_message');
            $table->text('stack_trace')->nullable();

            // Timestamp
            $table->timestamp('created_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('error_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('error_logs');
    }
};