<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Faker\Factory as Faker;

class CustomerSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        // Create 100 customers
        for ($i = 0; $i < 100; $i++) {
            $gender = $faker->randomElement(['male', 'female']);
            $maritalStatus = $faker->randomElement(['single', 'married', 'divorced', 'widowed']);
            $employmentStatus = $faker->randomElement(['employed', 'unemployed', 'self-employed', 'retired']);
            
            DB::table('customers')->insert([
                'first_name' => $faker->firstName($gender),
                'middle_name' => rand(0, 1) ? $faker->firstName : null, // 50% chance of having middle name
                'last_name' => $faker->lastName,
                'gender' => $gender,
                'date_of_birth' => $faker->dateTimeBetween('-80 years', '-18 years')->format('Y-m-d'),
                'place_of_birth' => $faker->city,
                'marital_status' => $maritalStatus,
                'nationality' => $faker->countryCode,
                'national_id' => $faker->unique()->numerify('#############'),
                'passport_number' => $faker->unique()->bothify('??#########'),
                'tax_id' => $faker->unique()->numerify('############'),
                'email' => $faker->unique()->safeEmail,
                'phone' => $faker->unique()->phoneNumber,
                'alt_phone' => rand(0, 1) ? $faker->phoneNumber : null,
                'email_verified_at' => rand(0, 1) ? now() : null,
                'phone_verified_at' => rand(0, 1) ? now() : null,
                'address' => $faker->streetAddress,
                'city' => $faker->city,
                'state' => $faker->state,
                'country' => $faker->country,
                'postal_code' => $faker->postcode,
                'occupation' => $faker->jobTitle,
                'employer_name' => $faker->company,
                'employer_address' => $faker->address,
                'employment_status' => $employmentStatus,
                'annual_income' => $faker->randomFloat(2, 1000, 500000),
                'profile_picture' => $faker->imageUrl(200, 200, 'people'),
                'customer_status' => $faker->randomElement(['active', 'inactive', 'blacklisted']),
                'notes' => rand(0, 1) ? $faker->paragraph : null,
                'source' => $faker->randomElement(['walk-in', 'website', 'agent', 'referral']),
                'password' => Hash::make('password'),
                'last_login_at' => $faker->dateTimeBetween('-6 months', 'now'),
                'created_by' => 1, // assuming user ID 1 is admin
                'updated_by' => 1,
                'preferred_contact_method' => $faker->randomElement(['email', 'phone', 'sms', 'whatsapp', 'telegram']),
                'allow_marketing_emails' => $faker->boolean,
                'allow_sms_notifications' => $faker->boolean,
                'allow_push_notifications' => $faker->boolean,
                'language_preference' => $faker->randomElement(['en', 'es', 'fr', 'de']),
                'timezone' => $faker->timezone,
                'created_at' => now(),
                'updated_at' => now(),
                'deleted_at' => null,
            ]);
        }
    }
}