<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;
use Carbon\Carbon;
use Illuminate\Support\Str;

class PaymentResponsesTableSeeder extends Seeder
{
    public function run(): void
    {
        $studentIds = [
            'JJU-2025-46107', 'DBU-2020-49162', 'BGU-2021-46912', 'MU-2025-77152',
            'BHU-2024-67355', 'JJU-2019-54927', 'BHU-2020-87090', 'DMU-2019-31865',
            // Add all remaining IDs...
            'HRU-2018-66842'
        ];

        $paymentMethods = ['cash', 'bank_transfer', 'mobile_money', 'credit_card'];
        $costCategoryIds = range(1, 10); // Adjust as needed

        $startDate = Carbon::parse('2024-01-01');
        $endDate = Carbon::now();

        $records = [];
        for ($i = 0; $i < 2000; $i++) {
            $randomDate = Carbon::createFromTimestamp(
                rand($startDate->timestamp, $endDate->timestamp)
            );

            $records[] = [
                'student_id' => $studentIds[array_rand($studentIds)],
                'cost_category_id' => $costCategoryIds[array_rand($costCategoryIds)],
                'amount' => mt_rand(1000, 100000) / 100,
                'payment_method' => $paymentMethods[array_rand($paymentMethods)],
                'paid_at' => $randomDate,
                'transaction_id' => Str::uuid(),
                'created_at' => now(),
                'updated_at' => now(),
            ];
        }

        foreach (array_chunk($records, 500) as $chunk) {
            DB::table('payments')->insert($chunk);
        }
    }
}
