<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class RegionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $regions = [
            ['name' => 'Addis Ababa', 'description' => 'Capital city region'],
            ['name' => 'Afar', 'description' => 'Eastern lowland region'],
            ['name' => 'Amhara', 'description' => 'Northwestern highland region'],
            ['name' => 'Benishangul-Gumuz', 'description' => 'Western region'],
            ['name' => 'Dire Dawa', 'description' => 'Chartered city'],
            ['name' => 'Gambela', 'description' => 'Western region near South Sudan'],
            ['name' => 'Harari', 'description' => 'Eastern region'],
            ['name' => 'Oromia', 'description' => 'Largest region'],
            ['name' => 'Sidama', 'description' => 'Newly formed region from SNNPR'],
            ['name' => 'Somali', 'description' => 'Eastern border region'],
            ['name' => 'South West Ethiopia Peoples\' Region', 'description' => 'New region split from SNNPR'],
            ['name' => 'Tigray', 'description' => 'Northern region'],
            ['name' => 'SNNPR', 'description' => 'Southern Nations, Nationalities, and Peoples\' Region'],
        ];

        foreach ($regions as $region) {
            DB::table('regions')->insert([
                'name' => $region['name'],
                'description' => $region['description'],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }
    }
}
