<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;
use Carbon\Carbon;
use Illuminate\Support\Str;

class PaymentsTableSeeder extends Seeder
{
    public function run(): void
    {
        $studentIds = [
            'JJU-2025-46107', 'DBU-2020-49162', 'BGU-2021-46912', 'MU-2025-77152',
            'BHU-2024-67355', 'JJU-2019-54927', 'BHU-2020-87090', 'DMU-2019-31865',
            'HRU-2018-66842'
            // Add more student IDs as needed
        ];

        $paymentMethods = ['Telebirr'];
        $costCategoryIds = range(1, 10); // Adjust to your real cost categories

        $startDate = Carbon::parse('2024-01-01');
        $endDate = Carbon::now();
        $daysCount = $startDate->diffInDays($endDate) + 1;

        $records = [];

        // 1. Ensure one record per day
        for ($i = 0; $i < $daysCount; $i++) {
            $date = $startDate->copy()->addDays($i)->setTime(rand(8, 18), rand(0, 59), rand(0, 59));

            $records[] = [
                'student_id' => $studentIds[array_rand($studentIds)],
                'cost_category_id' => $costCategoryIds[array_rand($costCategoryIds)],
                'amount' => mt_rand(1000, 100000) / 100,
                'payment_method' => 'Telebirr',
                'paid_at' => $date,
                'transaction_id' => Str::uuid(),
                'created_at' => now(),
                'updated_at' => now(),
            ];
        }

        // 2. Generate the remaining records randomly (to total 2000)
        $remaining = 2000 - count($records);
        for ($i = 0; $i < $remaining; $i++) {
            $randomDate = Carbon::createFromTimestamp(rand($startDate->timestamp, $endDate->timestamp))
                                ->setTime(rand(8, 18), rand(0, 59), rand(0, 59));

            $records[] = [
                'student_id' => $studentIds[array_rand($studentIds)],
                'cost_category_id' => $costCategoryIds[array_rand($costCategoryIds)],
                'amount' => mt_rand(1000, 100000) / 100,
                'payment_method' => 'Telebirr',
                'paid_at' => $randomDate,
                'transaction_id' => Str::uuid(),
                'created_at' => now(),
                'updated_at' => now(),
            ];
        }

        // 3. Insert in chunks
        foreach (array_chunk($records, 500) as $chunk) {
            DB::table('payments')->insert($chunk);
        }
    }
}
