<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class UniversitiesTableSeeder extends Seeder
{
    public function run()
    {
        $now = Carbon::now();

        $universities = [
            [
                'name' => 'Addis Ababa University',
                'code' => 'AAU',
                'location' => 'Addis Ababa',
                'description' => 'Premier higher education institution in Ethiopia established in 1950'
            ],
            [
                'name' => 'Adigrat University',
                'code' => 'ADU',
                'location' => 'Adigrat',
                'description' => 'Public university in Tigray Region focusing on technology and health sciences'
            ],
            [
                'name' => 'Aksum University',
                'code' => 'AKSU',
                'location' => 'Aksum',
                'description' => 'Institution near historical sites with programs in archaeology and tourism'
            ],
            [
                'name' => 'Ambo University',
                'code' => 'AMU',
                'location' => 'Ambo',
                'description' => 'Comprehensive university with strengths in agriculture and engineering'
            ],
            [
                'name' => 'Arba Minch University',
                'code' => 'ARMIN',
                'location' => 'Arba Minch',
                'description' => 'Specializes in water technology and engineering near Lakes Abaya and Chamo'
            ],
            [
                'name' => 'Arsi University',
                'code' => 'ARSU',
                'location' => 'Asella',
                'description' => 'Focuses on agricultural research and food security studies'
            ],
            [
                'name' => 'Assosa University',
                'code' => 'ASU',
                'location' => 'Assosa',
                'description' => 'Serves Benishangul-Gumuz Region with mining engineering programs'
            ],
            [
                'name' => 'Bahir Dar University',
                'code' => 'BDU',
                'location' => 'Bahir Dar',
                'description' => 'Leading institution near Lake Tana with strong engineering programs'
            ],
            [
                'name' => 'Bonga University',
                'code' => 'BGU',
                'location' => 'Bonga',
                'description' => 'Focuses on forestry, agriculture and environmental conservation'
            ],
            [
                'name' => 'Borena University',
                'code' => 'BRU',
                'location' => 'Mega',
                'description' => 'Serves pastoral communities with livestock and range management programs'
            ],
            [
                'name' => 'Bule Hora University',
                'code' => 'BHU',
                'location' => 'Bule Hora',
                'description' => 'Institution in Oromia Region with business and education programs'
            ],
            [
                'name' => 'Debark University',
                'code' => 'DKU',
                'location' => 'Debark',
                'description' => 'Gateway institution to Simien Mountains with tourism and conservation programs'
            ],
            [
                'name' => 'Debre Berhan University',
                'code' => 'DBU',
                'location' => 'Debre Berhan',
                'description' => 'Growing institution with focus on teacher education and computer science'
            ],
            [
                'name' => 'Debre Markos University',
                'code' => 'DMU',
                'location' => 'Debre Markos',
                'description' => 'Offers programs in health sciences, business and social sciences'
            ],
            [
                'name' => 'Debre Tabor University',
                'code' => 'DTU',
                'location' => 'Debre Tabor',
                'description' => 'Institution in South Gondar with agriculture and education programs'
            ],
            [
                'name' => 'Dembi Dolo University',
                'code' => 'DDO',
                'location' => 'Dembi Dolo',
                'description' => 'Serves western Ethiopia with agriculture and natural resource programs'
            ],
            [
                'name' => 'Dila University',
                'code' => 'DU',
                'location' => 'Dila',
                'description' => 'Focuses on coffee research, agriculture and business in southern Ethiopia'
            ],
            [
                'name' => 'Dire Dawa University',
                'code' => 'DDU',
                'location' => 'Dire Dawa',
                'description' => 'Strategic institution with logistics and engineering programs'
            ],
            [
                'name' => 'Ethiopian Police University',
                'code' => 'EPU',
                'location' => 'Addis Ababa',
                'description' => 'Specialized institution for police science and law enforcement education'
            ],
            [
                'name' => 'Gambella University',
                'code' => 'GMU',
                'location' => 'Gambella',
                'description' => 'Focuses on river basin management and cross-border studies'
            ],
            [
                'name' => 'Haramaya University',
                'code' => 'HRU',
                'location' => 'Haramaya',
                'description' => 'One of Ethiopia\'s oldest universities renowned for agricultural research'
            ],
            [
                'name' => 'Hawassa University',
                'code' => 'HWU',
                'location' => 'Hawassa',
                'description' => 'Comprehensive university with strong programs in medicine and environmental science'
            ],
            [
                'name' => 'Injibara University',
                'code' => 'IJU',
                'location' => 'Injibara',
                'description' => 'Focuses on water resource management and highland agriculture'
            ],
            [
                'name' => 'Jigjiga University',
                'code' => 'JJU',
                'location' => 'Jijiga',
                'description' => 'Key institution in Somali Region with dryland agriculture programs'
            ],
            [
                'name' => 'Jimma University',
                'code' => 'JU',
                'location' => 'Jimma',
                'description' => 'Known for community-based education model in health and agriculture'
            ],
            [
                'name' => 'Jinka University',
                'code' => 'JKU',
                'location' => 'Jinka',
                'description' => 'Focuses on indigenous studies and biodiversity conservation'
            ],
            [
                'name' => 'Kebri Dehar University',
                'code' => 'KDU',
                'location' => 'Kebri Dehar',
                'description' => 'Serves Somali Region with pastoral development programs'
            ],
            [
                'name' => 'Kotebe Education University',
                'code' => 'KEU',
                'location' => 'Addis Ababa',
                'description' => 'Specialized institution for teacher education and pedagogical research'
            ],
            [
                'name' => 'Madda Walabu University',
                'code' => 'MWU',
                'location' => 'Bale Robe',
                'description' => 'Focuses on biodiversity conservation and ecotourism studies'
            ],
            [
                'name' => 'Mattu University',
                'code' => 'MTU',
                'location' => 'Mattu',
                'description' => 'Institution in Illubabor Zone with agriculture and education programs'
            ],
            [
                'name' => 'Mekdela Amba University',
                'code' => 'MAU',
                'location' => 'Tulu Awuliya',
                'description' => 'New institution in South Wollo focusing on mining technology'
            ],
            [
                'name' => 'Mekelle University',
                'code' => 'MU',
                'location' => 'Mekelle',
                'description' => 'Major research university in Northern Ethiopia with engineering programs'
            ]
        ];

        $records = [];
        foreach ($universities as $university) {
            $records[] = array_merge($university, [
                'created_at' => $now,
                'updated_at' => $now
            ]);
        }

        DB::table('universities')->insert($records);
    }
}