@extends('layouts.master')

@section('title', 'Flash-icons')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/prism.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Flash Icons</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Animation</li>
                <li class="breadcrumb-item f-w-400 active">Flash Icons</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Pulse Animation</h4>
                        <p class="mb-0 mt-1">You can use the <code>main-animate</code> and <code>pulse-wrapper</code>
                            classes for the pulse animation.</p>
                    </div>
                    <div class="card-body pulse-wrapper main-animate">
                        <div class="row g-3">
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Stroke Icons</h6>
                                    <div class="common-flex"> <a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-calendar') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-ui-kits') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-bookmark') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-to-do') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-table') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-animation') }}">
                                                </use>
                                            </svg></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Fill Icons </h6>
                                    <div class="common-flex"> <a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-calender') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-ui-kits') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-bookmark') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-to-do') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-table') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-animation') }}"></use>
                                            </svg></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Feather Icons </h6>
                                    <div class="common-flex"> <a href="#!"> <i data-feather="gitlab"></i></a><a
                                            href="#!"> <i data-feather="twitter"></i></a><a href="#!"> <i
                                                data-feather="youtube"></i></a><a href="#!"> <i
                                                data-feather="thumbs-up"></i></a><a href="#!"> <i
                                                data-feather="instagram"></i></a><a href="#!"> <i
                                                data-feather="github"></i></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Ico Icons </h6>
                                    <div class="common-flex"> <a href="#!"> <i
                                                class="icofont icofont-hotel-boy-alt"></i></a><a href="#!"> <i
                                                class="icofont icofont-boy"></i></a><a href="#!"> <i
                                                class="icofont icofont-girl"></i></a><a href="#!"> <i
                                                class="icofont icofont-business-man"></i></a><a href="#!"> <i
                                                class="icofont icofont-man-in-glasses"></i></a><a href="#!"> <i
                                                class="icofont icofont-business-man-alt-1"></i></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Fontawesome Icons </h6>
                                    <div class="common-flex"> <a href="#!"> <i class="fa fa-sun-o"></i></a><a
                                            href="#!"> <i class="fa fa-linux"></i></a><a href="#!"> <i
                                                class="fa fa-stack-overflow"></i></a><a href="#!"> <i
                                                class="fa fa-windows"></i></a><a href="#!"> <i
                                                class="fa fa-reddit"></i></a><a href="#!"> <i
                                                class="fa fa-dropbox"></i></a></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Pulse Double Border Animation</h4>
                        <p class="mb-0 mt-1">You can use the <code>main-animate , border-pulse-wrapper ,</code> and
                            <code>pulse-wrapper</code> classes for the double border pulse animation.
                        </p>
                    </div>
                    <div class="card-body pulse-wrapper main-animate border-pulse-wrapper">
                        <div class="row g-3">
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Stroke Icons</h6>
                                    <div class="common-flex"> <a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-calendar') }}">
                                                </use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-ui-kits') }}">
                                                </use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-bookmark') }}">
                                                </use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-to-do') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-table') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-animation') }}">
                                                </use>
                                            </svg></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Fill Icons </h6>
                                    <div class="common-flex"> <a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-calender') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-ui-kits') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-bookmark') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-to-do') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-table') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-animation') }}">
                                                </use>
                                            </svg></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Feather Icons </h6>
                                    <div class="common-flex"> <a href="#!"> <i data-feather="gitlab"></i></a><a
                                            href="#!"> <i data-feather="twitter"></i></a><a href="#!"> <i
                                                data-feather="youtube"></i></a><a href="#!"> <i
                                                data-feather="thumbs-up"></i></a><a href="#!"> <i
                                                data-feather="instagram"></i></a><a href="#!"> <i
                                                data-feather="github"></i></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Ico Icons </h6>
                                    <div class="common-flex"> <a href="#!"> <i
                                                class="icofont icofont-hotel-boy-alt"></i></a><a href="#!"> <i
                                                class="icofont icofont-boy"></i></a><a href="#!"> <i
                                                class="icofont icofont-girl"></i></a><a href="#!"> <i
                                                class="icofont icofont-business-man"></i></a><a href="#!"> <i
                                                class="icofont icofont-man-in-glasses"></i></a><a href="#!"> <i
                                                class="icofont icofont-business-man-alt-1"></i></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Fontawesome Icons </h6>
                                    <div class="common-flex"> <a href="#!"> <i class="fa fa-sun-o"></i></a><a
                                            href="#!"> <i class="fa fa-linux"></i></a><a href="#!"> <i
                                                class="fa fa-stack-overflow"></i></a><a href="#!"> <i
                                                class="fa fa-windows"></i></a><a href="#!"> <i
                                                class="fa fa-reddit"></i></a><a href="#!"> <i
                                                class="fa fa-dropbox"></i></a></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Pulse Rhombus Animation</h4>
                        <p class="mb-0 mt-1">You can use the <code>main-animate , pulse-rhombus</code> and
                            <code>pulse-wrapper</code> classes for the clippath shaped pulse animation.
                        </p>
                    </div>
                    <div class="card-body pulse-wrapper main-animate pulse-rhombus">
                        <div class="row g-3">
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Stroke Icons</h6>
                                    <div class="common-flex"> <a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-calendar') }}">
                                                </use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-ui-kits') }}">
                                                </use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-bookmark') }}">
                                                </use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-to-do') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-table') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="stroke-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-animation') }}">
                                                </use>
                                            </svg></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Fill Icons </h6>
                                    <div class="common-flex"> <a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-calender') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-ui-kits') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-bookmark') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-to-do') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-table') }}"></use>
                                            </svg></a><a href="#!">
                                            <svg class="fill-icon">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-animation') }}">
                                                </use>
                                            </svg></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Feather Icons</h6>
                                    <div class="common-flex"> <a href="#!"> <i data-feather="gitlab"></i></a><a
                                            href="#!"> <i data-feather="twitter"></i></a><a href="#!"> <i
                                                data-feather="youtube"></i></a><a href="#!"> <i
                                                data-feather="thumbs-up"></i></a><a href="#!"> <i
                                                data-feather="instagram"></i></a><a href="#!"> <i
                                                data-feather="github"></i></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Ico Icons </h6>
                                    <div class="common-flex"> <a href="#!"> <i
                                                class="icofont icofont-hotel-boy-alt"></i></a><a href="#!"> <i
                                                class="icofont icofont-boy"></i></a><a href="#!"> <i
                                                class="icofont icofont-girl"></i></a><a href="#!"> <i
                                                class="icofont icofont-business-man"></i></a><a href="#!"> <i
                                                class="icofont icofont-man-in-glasses"></i></a><a href="#!"> <i
                                                class="icofont icofont-business-man-alt-1"></i></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Fontawesome Icons </h6>
                                    <div class="common-flex"> <a href="#!"> <i class="fa fa-sun-o"></i></a><a
                                            href="#!"> <i class="fa fa-linux"></i></a><a href="#!"> <i
                                                class="fa fa-stack-overflow"></i></a><a href="#!"> <i
                                                class="fa fa-windows"></i></a><a href="#!"> <i
                                                class="fa fa-reddit"></i></a><a href="#!"> <i
                                                class="fa fa-dropbox"></i></a></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Pulse Colored Animation</h4>
                        <p class="mb-0 mt-1">You can use the <code>main-animate , pulse-rabbet ,</code> and
                            <code>pulse-wrapper</code> classes for the colored SVG pulse animation.
                        </p>
                    </div>
                    <div class="card-body pulse-wrapper main-animate pulse-rabbet">
                        <div class="row g-3">
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Stroke Icons</h6>
                                    <div class="common-flex"> <a class="bg-light-primary" href="#!">
                                            <svg class="stroke-primary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-calendar') }}">
                                                </use>
                                            </svg></a><a class="bg-light-primary" href="#!">
                                            <svg class="stroke-primary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-ui-kits') }}">
                                                </use>
                                            </svg></a><a class="bg-light-primary" href="#!">
                                            <svg class="stroke-primary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-bookmark') }}">
                                                </use>
                                            </svg></a><a class="bg-light-primary" href="#!">
                                            <svg class="stroke-primary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-to-do') }}"></use>
                                            </svg></a><a class="bg-light-primary" href="#!">
                                            <svg class="stroke-primary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-table') }}"></use>
                                            </svg></a><a class="bg-light-primary" href="#!">
                                            <svg class="stroke-primary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#stroke-animation') }}">
                                                </use>
                                            </svg></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Fill Icons </h6>
                                    <div class="common-flex"> <a class="bg-light-secondary" href="#!">
                                            <svg class="fill-secondary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-calender') }}"></use>
                                            </svg></a><a class="bg-light-secondary" href="#!">
                                            <svg class="fill-secondary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-ui-kits') }}"></use>
                                            </svg></a><a class="bg-light-secondary" href="#!">
                                            <svg class="fill-secondary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-bookmark') }}"></use>
                                            </svg></a><a class="bg-light-secondary" href="#!">
                                            <svg class="fill-secondary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-to-do') }}"></use>
                                            </svg></a><a class="bg-light-secondary" href="#!">
                                            <svg class="fill-secondary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-table') }}"></use>
                                            </svg></a><a class="bg-light-secondary" href="#!">
                                            <svg class="fill-secondary">
                                                <use href="{{ asset('assets/svg/icon-sprite.svg#fill-animation') }}">
                                                </use>
                                            </svg></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Feather Icons </h6>
                                    <div class="common-flex"> <a class="bg-light-success" href="#!"> <i
                                                class="stroke-success" data-feather="gitlab"></i></a><a
                                            class="bg-light-success" href="#!"> <i class="stroke-success"
                                                data-feather="twitter"></i></a><a class="bg-light-success"
                                            href="#!"> <i class="stroke-success" data-feather="youtube"></i></a><a
                                            class="bg-light-success" href="#!"> <i class="stroke-success"
                                                data-feather="thumbs-up"></i></a><a class="bg-light-success"
                                            href="#!"> <i class="stroke-success" data-feather="instagram"></i></a><a
                                            class="bg-light-success" href="#!"> <i class="stroke-success"
                                                data-feather="github"></i></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Ico Icons </h6>
                                    <div class="common-flex"> <a class="bg-light-warning" href="#!"> <i
                                                class="txt-warning icofont icofont-hotel-boy-alt"></i></a><a
                                            class="bg-light-warning" href="#!"> <i
                                                class="txt-warning icofont icofont-boy"></i></a><a
                                            class="bg-light-warning" href="#!"> <i
                                                class="txt-warning icofont icofont-girl"></i></a><a
                                            class="bg-light-warning" href="#!"> <i
                                                class="txt-warning icofont icofont-business-man"></i></a><a
                                            class="bg-light-warning" href="#!"> <i
                                                class="txt-warning icofont icofont-man-in-glasses"></i></a><a
                                            class="bg-light-warning" href="#!"> <i
                                                class="txt-warning icofont icofont-business-man-alt-1"></i></a></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xxl-4">
                                <div class="card-wrapper border rounded-3">
                                    <h6 class="sub-title fw-bold">Fontawesome Icons </h6>
                                    <div class="common-flex"> <a class="bg-light-info" href="#!"> <i
                                                class="fa fa-sun-o txt-info"></i></a><a class="bg-light-info"
                                            href="#!"> <i class="fa fa-linux txt-info"></i></a><a
                                            class="bg-light-info" href="#!"> <i
                                                class="fa fa-stack-overflow txt-info"></i></a><a class="bg-light-info"
                                            href="#!"> <i class="fa fa-windows txt-info"></i></a><a
                                            class="bg-light-info" href="#!"> <i
                                                class="fa fa-reddit txt-info"></i></a><a class="bg-light-info"
                                            href="#!"> <i class="fa fa-dropbox txt-info"></i></a></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Heart-beat Animation</h4>
                        <p class="mb-0 mt-1">You can use the <code>main-animate</code> and <code>heartbeat-wrapper</code>
                            classes for the colored SVG pulse animation.</p>
                    </div>
                    <div class="card-body heartbeat-wrapper main-animate">
                        <div class="common-flex"> <a href="#!"> <i class="icon-heart-broken"></i></a><a
                                href="#!"> <i data-feather="heart"></i></a><a href="#!"> <i
                                    class="fa fa-heart"></i></a><a href="#!"> <i
                                    class="icofont icofont-heart-beat"></i></a><a href="#!"> <i class="icon-heart">
                                </i></a></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/prism/prism.min.js') }}"></script>
    <script src="{{ asset('assets/js/clipboard/clipboard.min.js') }}"></script>
    <script src="{{ asset('assets/js/custom-card/custom-card.js') }}"></script>
    <!-- calendar js-->
    <script src="{{ asset('assets/js/height-equal.js') }}"></script>
@endsection
