@extends('others_layouts.authentication_layouts.master')

@section('title', 'Login')

@section('css')

@endsection

@section('main_content')
    <div class="container-fluid">
        <div class="row">

            <div class="col-xl-5"><img class="bg-img-cover bg-center" src="{{ asset('assets/images/login/3.jpg') }}"
                    alt="looginpage"></div>
            <div class="col-xl-7 p-0">

        <div class="date_top">

        <span class="ec_today"></span> &nbsp;<span class="year_today"></span> &nbsp; <span class="hour" ></span><span class="min"></span><span class="sec"></span>

        </div>
                <div class="login-card login-dark">
                    <div>
                        <div><a class="logo text-start" href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                                    src="{{ asset('assets/images/logo/logo_dark.png') }}" alt="looginpage"><img
                                    class="img-fluid for-dark" src="{{ asset('assets/images/logo/logo_dark.png') }}"
                                    alt="looginpage"><b style="font-size: 25px; color: white;">CSPS Admin Panel</b></a></div>
                                    <div class="login-main">
                            <form id="loginForm" class="theme-form" >
                                @csrf
                                <h4>Sign in to account</h4>
                                <p>Enter your email & password to login</p>

                                <div id="errorMessage"></div>
                                <div id="successMessage"></div>

                                <div class="form-group">
                                    <label class="col-form-label">Email Address</label>
                                    <input class="form-control  @error('email') is-invalid @enderror clearable" id="email" type="email" name="email" value="" required autocomplete="email" autofocus placeholder="Enter email address">
                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label class="col-form-label">Password</label>
                                    <div class="form-input position-relative">
                                        <input class="form-control @error('password') is-invalid @enderror clearable" id="password" type="password" name="password" value="" required autocomplete="current-password"
                                            placeholder="Enter password">
                                        <div class="show-hide"><span class="show"> </span></div>
                                        @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                    </div>
                                </div>

                                <div class="form-group mb-0">


                                    <div class="checkbox p-0">
                                        <input id="checkbox1" type="checkbox" class="form-check-input">
                                        <label class="text-muted" for="checkbox1">Remember password</label>
                                    </div>


                                    @if (Route::has('password.request'))
                                        <a class="link" href="{{ route('password.request') }}">
                                            {{ __('Forgot password?') }}
                                        </a>
                                    @endif

                                    <div class="text-end mt-3">
                                        <button name="btn-login" id='btn-login'  class="btn btn-primary btn-block w-100" type="submit">Sign in <i class="icofont icofont-sign-in"></i></button>
                                    </div>
                                </div>


                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

@endsection
