@extends('layouts.master')

@section('title', 'Ratios')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/prism.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Ratios</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Bonus Ui</li>
                <li class="breadcrumb-item f-w-400 active">Ratios</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xxl-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Aspect Ratios</h4>
                        <p class="f-m-light mt-1">Aspect ratios can be customized with modifier classes. By default the
                            following ratio classes are provided:<code>[ratio-1x1 / ratio-4x3 / ratio-16x9 /
                                ratio-21x9]</code>.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <div class="col-lg-3 col-sm-6">
                                <div class="ratio ratio-1x1">
                                    <iframe src="https://www.youtube.com/embed/AsZwvuUmHGU?si=LHExkFd586NQbVAG"
                                        title="YouTube video" allowfullscreen=""></iframe>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6">
                                <div class="ratio ratio-4x3">
                                    <iframe src="https://www.youtube.com/embed/qDL2HBPy9uQ?si=yyIowrbZW-C-3lxd"
                                        title="YouTube video" allowfullscreen=""></iframe>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6">
                                <div class="ratio ratio-16x9">
                                    <iframe src="https://www.youtube.com/embed/AsZwvuUmHGU?si=LHExkFd586NQbVAG"
                                        title="YouTube video" allowfullscreen=""></iframe>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6">
                                <div class="ratio ratio-21x9">
                                    <iframe src="https://www.youtube.com/embed/qDL2HBPy9uQ?si=yyIowrbZW-C-3lxd"
                                        title="YouTube video" allowfullscreen=""></iframe>
                                </div>
                            </div>
                        </div>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#aspect-ratio"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="aspect-ratio">&lt;div class="row gap-lg-0 gap-4"&gt;
 &lt;div class="col-lg-3"&gt;
   &lt;div class="ratio ratio-1x1"&gt;
     &lt;iframe src="https://www.youtube.com/embed/AsZwvuUmHGU?si=LHExkFd586NQbVAG" title="YouTube video" allowfullscreen=""&gt;&lt;/iframe&gt;
   &lt;/div&gt;
 &lt;/div&gt;
 &lt;div class="col-lg-3"&gt;
   &lt;div class="ratio ratio-4x3"&gt;
     &lt;iframe src="https://www.youtube.com/embed/qDL2HBPy9uQ?si=yyIowrbZW-C-3lxd" title="YouTube video" allowfullscreen=""&gt;&lt;/iframe&gt;
   &lt;/div&gt;
 &lt;/div&gt;
 &lt;div class="col-lg-3"&gt;
   &lt;div class="ratio ratio-16x9"&gt;
     &lt;iframe src="https://www.youtube.com/embed/AsZwvuUmHGU?si=LHExkFd586NQbVAG" title="YouTube video" allowfullscreen=""&gt;&lt;/iframe&gt;
   &lt;/div&gt;
 &lt;/div&gt;
 &lt;div class="col-lg-3"&gt;
   &lt;div class="ratio ratio-21x9"&gt;
     &lt;iframe src="https://www.youtube.com/embed/qDL2HBPy9uQ?si=yyIowrbZW-C-3lxd" title="YouTube video" allowfullscreen=""&gt;&lt;/iframe&gt;
   &lt;/div&gt;
 &lt;/div&gt;
&lt;/div&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Custom Ratio</h4>
                        <p class="f-m-light mt-1">Wrap any embed, like an <code>&lt;iframe&gt;</code> , in a parent element
                            with <code>ratio </code>and an <code>aspect ratio</code> class. Here is a breakdown of these
                            ratios:<code> ratio-4x3</code>.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="ratio ratio-4x3">
                            <iframe src="https://www.youtube.com/embed/AsZwvuUmHGU?si=LHExkFd586NQbVAG"
                                title="YouTube video" allowfullscreen=""></iframe>
                        </div>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#custom-ratio"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="custom-ratio">&lt;div class="ratio ratio-4x3"&gt;
 &lt;iframe src="https://www.youtube.com/embed/AsZwvuUmHGU?si=LHExkFd586NQbVAG" title="YouTube video" allowfullscreen=""&gt;&lt;/iframe&gt;
&lt;/div&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Default Ratio</h4>
                        <p class="f-m-light mt-1">Wrap any embed, like an <code>&lt;iframe&gt;</code> , in a parent element
                            with <code>ratio </code>and an <code>aspect ratio</code> class. Here is a breakdown of these
                            ratios:<code> 16x9 ratio</code>.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="ratio ratio-16x9">
                            <iframe src="https://www.youtube.com/embed/qDL2HBPy9uQ?si=yyIowrbZW-C-3lxd"
                                title="YouTube video" allowfullscreen=""> </iframe>
                        </div>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#default-ratio"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="default-ratio">&lt;div class="ratio ratio-16x9"&gt;
 &lt;iframe src="https://www.youtube.com/embed/qDL2HBPy9uQ?si=yyIowrbZW-C-3lxd" title="YouTube video" allowfullscreen=""&gt;&lt;/iframe&gt;
&lt;/div&gt;       </code></pre>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/prism/prism.min.js') }}"></script>
    <script src="{{ asset('assets/js/clipboard/clipboard.min.js') }}"></script>
    <script src="{{ asset('assets/js/custom-card/custom-card.js') }}"></script>
@endsection
