<!DOCTYPE html>
<html lang="en" @if (Route::currentRouteName()=='admin.rtl_layout') dir="rtl" @endif>

<head>
    @include('layouts.head')
    @include('layouts.css')
</head>

@switch(Route::currentRouteName())
    @case('admin.box_layout')
        <body class="box-layout">
        @break

    @case('admin.rtl_layout')
        <body class="rtl">
        @break

    @case('admin.dark_layout')
        <body class="dark-only">
        @break

    @default
        <body>
@endswitch

    <!-- loader starts-->
    <div class="loader-wrapper">
    <div class="loader loader-1">
        <div class="loader-outter"></div>
        <div class="loader-inner"></div>
        <div class="loader-inner-1"></div>
        <img src="{{ asset('assets/images/loader.png') }}" alt="Logo" class="loader-logo">
    </div>
</div>
    <!-- loader ends-->

    <!-- tap on top starts-->
    {{-- <div class="tap-top"><i data-feather="chevrons-up"></i></div> --}}
    {{-- <div class="paginacontainer">
        <div class="progress-wrap">
          <svg class="progress-circle svg-content" width="100%" height="100%" viewbox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"></path>
          </svg>
        </div>
    </div> --}}
    <!-- tap on tap ends-->

    <!-- page-wrapper Start-->
    <div class="page-wrapper compact-wrapper" id="pageWrapper">

        <div class="page-header row">
            @yield('breadcrumb')

            <!-- Page header start -->
            @include('layouts.header')
            <!-- Page header end-->

        </div>
        <!-- Page Body Start-->
        <div class="page-body-wrapper">

            <!-- Page sidebar start-->
            @include('layouts.sidebar')
            <!-- Page sidebar end-->

            <div class="page-body">
                @yield('main_content')
            </div>

            <!-- footer start-->
            @include('layouts.footer')
            <!-- footer end-->
        </div>

    </div>

    {{-- scripts --}}
    @include('layouts.script')
    @include('admin.inc.alerts')
    {{-- end scripts --}}

</body>

</html>
