@extends('layouts.master')

@section('title', 'Hide Menu On Scroll')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/date-picker.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Hide Menu On Scroll</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Page Layout</li>
                <li class="breadcrumb-item f-w-400 active">Hide Menu On Scroll</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Sample Card</h4>
                        <p class="f-m-light mt-1">A sample card of the mofi theme.</p>
                    </div>
                    <div class="card-body">
                        <p>
                            A qualified expert who is in charge of developing and designing websites is known as a web
                            designer. They make advantage of their knowledge of current web design trends to create websites
                            that are both aesthetically pleasing and user-friendly. Making sure that the websites they
                            develop are responsive—that is, that they easily adjust to multiple screen sizes and devices—is
                            a crucial component of their work. This guarantees that users, regardless of the device they are
                            using, can access and navigate the website efficiently.</p>
                        <p>A web designer is technically proficient as well as having a good sense of aesthetics and colour.
                            They take care to choose colour palettes that go with the corporate identity and deliver the
                            intended message. The website's efficacy and overall user experience can be significantly
                            impacted by the colour scheme. A web designer can develop a visually appealing website that
                            grabs visitors' attention and improves their surfing experience by adding the right color
                            choices.</p>
                        <p>Web designers use CSS as a crucial tool to realise their creative ambitions. The layout,
                            appearance, and style of web pages are managed using this language. To maintain uniformity and
                            coherence throughout the website, a web designer's CSS knowledge is essential. Every component
                            of the website may be altered with CSS, from typefaces and spacing to picture and button
                            placement. By leveraging CSS, a web designer is able to create a visually stunning website that
                            aligns with the client's objectives and enhances the user's interaction with the site.</p>
                        <p>A web designer not only concentrates on producing websites that are aesthetically pleasing but
                            also pays great attention to the appropriate use of colour. They are aware of the psychology
                            underlying colour and how it might influence people' feelings and behaviours. A web designer may
                            create a unified and aesthetically pleasant experience for visitors by carefully selecting
                            colour schemes that complement the brand and message of the website.</p>
                        <p>A practitioner with expertise in building attractive and useful websites is known as a web
                            designer. Their primary objective is to create responsive websites, which can adjust to and show
                            properly on various platforms including PCs, tablets, and mobile phones. A web designer gives
                            considerable thought to a website's style, navigation, and general user experience to make sure
                            the target audience will find it easy to use and visually appealing.</p>
                        <p>Knowledge of user psychology, design concepts, and usability testing techniques are essential for
                            UX designers. Additionally, they must possess strong communication skills with both technical
                            and user stakeholders.training and education The educational road to become a UX designer is not
                            one-size-fits-all. The majority of UX designers, however, have degrees in design, computer
                            science, or human-computer interaction. Additionally, there are several UX design courses and
                            bootcamps that are offered both online and in person.Career prospects: Job prospects for UX
                            designers are excellent. UX designers' employment is expected to increase by 13% between 2020
                            and 2030, according to the Bureau of Labour Statistics, which is substantially faster than the
                            average for all occupations.Making a product or service functional, pleasurable, and accessible
                            is the responsibility of the UX designer. Although many businesses create user experiences, the
                            phrase is frequently connected to digital design for websites and mobile applications. The broad
                            design phases tend to remain the same, even though the actual process changes from product to
                            product and firm to company.</p>
                        <p>
                            The professional who is in charge with designing a website's visual elements is known as a web
                            designer. Their primary priorities are with a website's aesthetics and user experience (UX), in
                            order to ensure that it conveys the intended message or corporate identity in an effective,
                            pleasing to the eye and comprehensible way. Web designers produce layouts, colour schemes,
                            typography, and other visual elements of a website using a variety of graphic design tools and
                            software. They frequently work along with stakeholders or clients to comprehend their brand
                            requirements and style preferences. UI design is the process used to create the forms, menus,
                            navigation, buttons, and other interface elements that users interact with on a website. To
                            improve the user experience overall, web designers pay attention on making all of these elements
                            straightforward and easy to use.</p>
                        <p>
                            Web designers need to make sure their websites are responsive, which means they can easily
                            adjust to various screen sizes and devices, given the growing popularity of mobile devices. This
                            involves developing adaptable layouts and optimising the user experience across desktop, tablet,
                            and smartphone platforms by implementing methodologies like media queries. Web designers
                            frequently draft wireframes or prototypes to describe the organisation, functionality, and
                            content hierarchy of a website before moving on to the graphic design stage. This aids in the
                            layout visualisation and modification process for them and their clients prior to moving forward
                            with the detailed design work.</p>
                        <p>
                            To see a website project through to its conclusion, web designers usually work in tandem with
                            other specialists, ranging including web developers, UX designers, content writers of note, and
                            project managers. Ensuring that the final product satisfies the client's objectives and
                            technical requirements necessitates efficient interpersonal interaction and cooperation among
                            participants. For websites to be both aesthetically pleasing and useful, a solid understanding
                            of design principles such as visual hierarchy, typography, colour theory, and composition is
                            essential. Web designers keep knowledgeable of new design trends and new developments in
                            technology while also always developing their artistic abilities. Making sure the website is
                            accessible and responsive on a range of devices and screen sizes is one of the main duties of a
                            web designer. The increasing number of smartphones and tablets has made it indispensable to
                            design with mobile devices in mind. A knowledgeable web designer uses fluid grids, responsive
                            design strategies, and flexible layouts in order to create fluid experiences that change with
                            the dimensions of the screen.</p>
                        <p>
                            Web designers frequently encounter challenging situations with client preferences, browser
                            compatibility, and layout restrictions. To get beyond these challenges and keep the integrity of
                            the design subject matter, they must be knowledgeable in solving problems and coming up with
                            solutions that are unique. The design and creation of visually appealing and user-friendly
                            internet pages that successfully communicate information, publicly promote business enterprises,
                            and encourage interaction among website visitors and through the internet conversions is
                            predominantly the accountability of web development professionals. Usually, the web design
                            process starts with a detailed reading comprehension of the client's requirements, target
                            market, and competitive environment. Equipped with this understanding, the web designer sets out
                            to create the framework, appearance, and visual style of the website. Before beginning the
                            development stage, they might produce wireframes and mockups that show the site's architecture
                            and components of design.</p>
                        <p>
                            A site designer is now very important in the digital age since the internet provides access to
                            information, entertainment, and business. A web designer is an important architect of virtual
                            user experiences in addition to being a maker of visually appealing websites. This essay
                            explores many different aspects of a web designer's job, including their creative process,
                            technical expertise, and contribution to the world of computers and smartphones. Web design is
                            fundamentally the art and science of creating visually magnificent useful, and user-friendly
                            websites. Creating an online presence that successfully conveys a client's brand identity,
                            message, and offerings is the main goal of a web designer. In order to meet the goals of the
                            customer and improve the user experience, components of design must strike an appropriate
                            equilibrium between imaginative thinking and a pragmatic perspective. Moreover, throughout the
                            design and development phase, web designers are frequently collaborating closely with
                            developers, content producers, and other stakeholders. Taking into account deadlines for
                            projects and budgetary constraints while becoming aware the client's vision necessitates
                            effective communication and teamwork. A web designer's responsibilities go well beyond simply
                            constructing websites that look good; they also include the science of user experience, the art
                            of narrative, and the craft of digital innovation. Web designers use their imagination and
                            technical know-how as digital landscape architects to have an impact on millions of individuals
                            who online experiences.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <!-- calendar js-->
    <script src="{{ asset('assets/js/hide-on-scroll.js') }}"></script>
    <script src="{{ asset('assets/js/tooltip-init.js') }}"></script>
@endsection
