<?php $__env->startSection('title', 'Financial Summary'); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/animate.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/datatables.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/date-range-picker/flatpickr.min.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/date-picker.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/owlcarousel.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/rating.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/vector-map.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/range-slider.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/fullcalender.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/chartist.css')); ?>">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />

    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">


    <style>
        .card-loader-wrapper {
            position: relative;
        }

        .card-loader-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.7);
            /* or rgba(0,0,0,0.2) for dark */
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 1rem;
            backdrop-filter: blur(2px);
            transition: opacity 0.3s ease;
        }

        .card-loader-overlay.hidden {
            opacity: 0;
            pointer-events: none;
        }

        #toast-container.toast-bottom-right {
            bottom: 1rem !important;
            right: 1rem !important;
            top: auto !important;
            left: auto !important;
            z-index: 99999;
        }



        .total-icon {
            display: flex;
            align-items: flex-start;
            /* aligns arrow and percent to top */
            gap: 4px;
            /* small space between arrow and percent */
        }

        .total-icon p {
            margin: 0;
            padding: 0;
            min-width: 14px;
            /* smaller width to reduce space */
            text-align: center;
            font-size: 11px;
            /* smaller arrow container */
            line-height: 1;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .total-icon p i {
            font-size: 11px;
            /* arrow icon size */
            line-height: 1;
        }

        .total-icon span {
            font-weight: 600;
            font-size: 11px;
            /* percent text size */
            line-height: 1.1;
            padding-top: 2px;
            /* nudge percent text a little down for better alignment */
        }
    </style>




<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="<?php echo e(route('admin.dashboard')); ?>"><img class="img-fluid for-light"
                    src="<?php echo e(asset('assets/images/logo/logo.png')); ?>" alt="" /><img class="img-fluid for-dark"
                    src="<?php echo e(asset('assets/images/logo/logo_light.png')); ?>" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Admin</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Dashboard</li>
                <li class="breadcrumb-item f-w-400 active">Financial Summary</li>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
    <div class="container-fluid">
        <!-- =======================
                         FINANCIAL SUMMARY SECTION
                    ========================== -->
        <section id="financial-summary-section" class="mb-5">
            <div class="container-fluid">
                <!-- Section Title -->
                <div class="row mb-3">
                    <div class="col-12">
                        <h3 class="fw-bold">📊 Financial Summary Overview</h3>
                        <p class="text-muted">Real-time insights into daily, weekly, monthly, and yearly transactions.</p>
                    </div>
                </div>

                <!-- Card Container -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card border">
                            <div class="card-header bg-light">
                                <h4 class="mb-0">Financial Summary</h4>
                            </div>
                            <div class="card-body">

                                <!-- Metric Cards Row -->
                                <div class="row g-3">

                                    
                                    <div class="col-xl-3 col-sm-6" id="daily-transaction-card">
                                        <div class="card shadow-none border common-hover">
                                            <div class="card-header card-no-border pb-0">
                                                <div class="header-top daily-revenue-card">
                                                    <h4>Daily Transaction</h4>
                                                    <div class="dropdown icon-dropdown">
                                                        <button class="btn dropdown-toggle" data-bs-toggle="dropdown">
                                                            <i class="icon-more-alt"></i>
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-end">
                                                            <a class="dropdown-item" href="#" data-date="today">Today</a>
                                                            <a class="dropdown-item" href="#"
                                                                data-date="yesterday">Yesterday</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="daily-transaction-body" class="card-body pb-0 total-sells">
                                                <div class="text-center my-5">
                                                    <div class="spinner-border text-primary" role="status"></div>
                                                </div>
                                                <div id="daily-transaction-chart" style="height: 120px;"></div>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div class="col-xl-3 col-sm-6">
                                        <div class="card shadow-none border common-hover ">
                                            <div class="card-header card-no-border pb-0">
                                                <div class="header-top daily-revenue-card">
                                                    <h4>Weekly Transaction</h4>
                                                    <div class="dropdown icon-dropdown">
                                                        <button class="btn dropdown-toggle" data-bs-toggle="dropdown"><i
                                                                class="icon-more-alt"></i></button>
                                                        <div class="dropdown-menu dropdown-menu-end">
                                                            <a class="dropdown-item" href="#" data-week="this">This Week</a>
                                                            <a class="dropdown-item" href="#" data-week="last">Last Week</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body pb-0 total-sells" id="weekly-transaction-body">
                                                <div class="weekly-summary-top">
                                                    <div class="d-flex justify-content-center align-items-center"
                                                        style="min-height: 100px;">
                                                        <div class="spinner-border text-primary" role="status">
                                                            <span class="visually-hidden">Loading...</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div id="weeklyChart" class="mt-3" style="min-height: 250px;"></div>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div class="col-xl-3 col-sm-6">
                                        <div class="card shadow-none border common-hover" id="monthly-transaction-card">
                                            <div class="card-header card-no-border pb-0">
                                                <div class="header-top daily-revenue-card">
                                                    <h4>Monthly Transaction</h4>
                                                    <div class="dropdown icon-dropdown">
                                                        <button class="btn dropdown-toggle" data-bs-toggle="dropdown"><i
                                                                class="icon-more-alt"></i></button>
                                                        <div class="dropdown-menu dropdown-menu-end">
                                                            <a class="dropdown-item" href="#" data-month="this">This
                                                                Month</a>
                                                            <a class="dropdown-item" href="#" data-month="last">Last
                                                                Month</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body pb-0 total-sells-3" id="monthly-transaction-body">
                                                <div class="monthly-summary-top">
                                                    <div class="d-flex justify-content-center align-items-center"
                                                        style="min-height: 100px;">
                                                        <div class="spinner-border text-primary" role="status">
                                                            <span class="visually-hidden">Loading...</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div id="monthlyChart" class="mt-3" style="min-height: 250px;"></div>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div class="col-xl-3 col-sm-6">
                                        <div class="card shadow-none border common-hover">
                                            <div class="card-header card-no-border pb-0">
                                                <div class="header-top daily-revenue-card">
                                                    <h4>Yearly Transaction</h4>
                                                    <div class="dropdown icon-dropdown">
                                                        <button class="btn dropdown-toggle" data-bs-toggle="dropdown"
                                                            aria-expanded="false">
                                                            <i class="icon-more-alt"></i>
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-end">
                                                            <a class="dropdown-item" href="#" data-year="this">This Year</a>
                                                            <a class="dropdown-item" href="#" data-year="last">Last Year</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body pb-0 total-sells-4">
                                                <div class="d-flex justify-content-center align-items-center"
                                                    style="min-height: 100px;">
                                                    <div class="spinner-border text-primary" role="status">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div>
                                                </div>
                                                <div id="yearlyTransactionChart" class="mt-3" style="min-height: 250px;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Breakdown Chart Row -->
                                <div class="row mt-3">
                                    <div class="col-xl-6 col-sm-12">
                                        <div class="card shadow-sm border">
                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                <h4 class="mb-0">Monthly Breakdown - Yearly Revenue</h4>
                                                <div class="dropdown">
                                                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                                        data-bs-toggle="dropdown">
                                                        Select Year
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" href="#" data-chart-year="this">This
                                                            Year</a>
                                                        <a class="dropdown-item" href="#" data-chart-year="last">Last
                                                            Year</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <canvas id="yearlyLineChart" height="120"></canvas>
                                                <button class="btn btn-link mt-3" data-bs-toggle="modal"
                                                    data-bs-target="#monthlyBreakdownModal">
                                                    View Monthly Breakdown
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-xl-6 col-sm-12">
                                        <div class="card shadow-sm border">
                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                <h4 class="mb-0">Recent Payments</h4>
                                            </div>
                                            <div class="card-body table-responsive">
                                                <table id="recentTransactionsTable"
                                                    class="table table-sm table-hover table-bordered mb-0 table-responsive theme-scrollbar">
                                                    <thead>
                                                        <tr>
                                                            <th style="width: 30px;">#</th>
                                                            <th>Student</th>
                                                            <th>Date</th>
                                                            <th>Method</th>
                                                            <th>Amount</th>
                                                            <th>Status</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody></tbody> 
                                                </table>
                                            </div>
                                        </div>
                                    </div>


                                </div>

                                <!-- Modal Placeholder -->
                                <!-- You can place your #monthlyBreakdownModal modal component here -->

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>


    </div>

    <div class="card shadow-sm mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Transaction Summary</h5>
            <div class="dropdown">
                <button class="btn btn-sm btn-light dropdown-toggle" data-bs-toggle="dropdown">
                    Filter Period
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="#" data-period="today">Today</a></li>
                    <li><a class="dropdown-item" href="#" data-period="week">This Week</a></li>
                    <li><a class="dropdown-item" href="#" data-period="month">This Month</a></li>
                </ul>
            </div>
        </div>

        <div class="card-body">
            <div class="row g-3">
                <!-- Number of Payments -->
                <div class="col-xl-3 col-sm-6">
                    <div class="card shadow-none border common-hover">
                        <div class="card-header card-no-border pb-0">
                            <div class="header-top daily-revenue-card">
                                <h4>Today’s Transactions</h4>
                                <div class="dropdown icon-dropdown">
                                    <button class="btn dropdown-toggle" data-bs-toggle="dropdown"><i
                                            class="icon-more-alt"></i></button>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <a class="dropdown-item" href="#" data-period="today">Today</a>
                                        <a class="dropdown-item" href="#" data-period="week">This Week</a>
                                        <a class="dropdown-item" href="#" data-period="month">This Month</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body pb-0 total-sells" id="payment-count-body">
                            <div class="weekly-summary-top d-flex justify-content-center align-items-center"
                                style="min-height: 100px;">
                                <div class="spinner-border text-primary" role="status"><span
                                        class="visually-hidden">Loading...</span></div>
                            </div>
                            <div id="paymentCountChart" class="mt-3" style="min-height: 250px;"></div>
                        </div>
                    </div>
                </div>

                <!-- Average Payment Value -->
                <div class="col-xl-3 col-sm-6">
                    <div class="card shadow-none border common-hover">
                        <div class="card-header card-no-border pb-0">
                            <div class="header-top daily-revenue-card">
                                <h4>Failed Transactions</h4>
                                <div class="dropdown icon-dropdown">
                                    <button class="btn dropdown-toggle" data-bs-toggle="dropdown"><i
                                            class="icon-more-alt"></i></button>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <a class="dropdown-item" href="#" data-period="week">This Week</a>
                                        <a class="dropdown-item" href="#" data-period="month">This Month</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body pb-0 total-sells" id="average-payment-body">
                            <div class="weekly-summary-top d-flex justify-content-center align-items-center"
                                style="min-height: 100px;">
                                <div class="spinner-border text-success" role="status"><span
                                        class="visually-hidden">Loading...</span></div>
                            </div>
                            <div id="averagePaymentChart" class="mt-3" style="min-height: 250px;"></div>
                        </div>
                    </div>
                </div>

                <!-- Largest Payment -->
                <div class="col-xl-3 col-sm-6">
                    <div class="card shadow-none border common-hover">
                        <div class="card-header card-no-border pb-0">
                            <div class="header-top daily-revenue-card">
                                <h4>Total Transactions</h4>
                                <div class="dropdown icon-dropdown">
                                    <button class="btn dropdown-toggle" data-bs-toggle="dropdown"><i
                                            class="icon-more-alt"></i></button>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <a class="dropdown-item" href="#" data-period="week">This Week</a>
                                        <a class="dropdown-item" href="#" data-period="month">This Month</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body pb-0 total-sells" id="largest-payment-body">
                            <div class="weekly-summary-top d-flex justify-content-center align-items-center"
                                style="min-height: 100px;">
                                <div class="spinner-border text-warning" role="status"><span
                                        class="visually-hidden">Loading...</span></div>
                            </div>
                            <div id="largestPaymentChart" class="mt-3" style="min-height: 250px;"></div>
                        </div>
                    </div>
                </div>

                <!-- Failed Transactions -->
                <div class="col-xl-3 col-sm-6">
                    <div class="card shadow-none border common-hover">
                        <div class="card-header card-no-border pb-0">
                            <div class="header-top daily-revenue-card">
                                <h4>Total Revenue</h4>
                                <div class="dropdown icon-dropdown">
                                    <button class="btn dropdown-toggle" data-bs-toggle="dropdown"><i
                                            class="icon-more-alt"></i></button>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <a class="dropdown-item" href="#" data-period="today">Today</a>
                                        <a class="dropdown-item" href="#" data-period="week">This Week</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body pb-0 total-sells" id="failed-transactions-body">
                            <div class="weekly-summary-top d-flex justify-content-center align-items-center"
                                style="min-height: 100px;">
                                <div class="spinner-border text-danger" role="status"><span
                                        class="visually-hidden">Loading...</span></div>
                            </div>
                            <div id="failedTransactionsChart" class="mt-3" style="min-height: 250px;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="monthlyBreakdownModal" tabindex="-1" aria-labelledby="monthlyBreakdownLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Monthly Revenue Breakdown</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <table class="table table-bordered table-hover" id="monthlyBreakdownTable">
                        <thead>
                            <tr>
                                <th>Month</th>
                                <th>Total Revenue (Br)</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>


    <script src="<?php echo e(asset('assets/js/chart/apex-chart/apex-chart.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/stock-prices.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/notify/bootstrap-notify.min.js')); ?>"></script>
    <!-- calendar js-->
    <script src="<?php echo e(asset('assets/js/dashboard/default.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/notify/index.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/datatable.custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/datatable.custom1.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datepicker/date-range-picker/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datepicker/date-range-picker/datepicker-range-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/handlebars.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/typeahead.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/typeahead.custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead-search/handlebars.js')); ?>"></script>




    <!-- calendar js-->
    <script src="<?php echo e(asset('assets/js/calendar/fullcalender.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/calendar/custom-calendar.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/chart/morris-chart/raphael.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/morris-chart/morris.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/morris-chart/prettify.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/apex-chart.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/stock-prices.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/echart/pie-chart/facePrint.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/echart/pie-chart/testHelper.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/echart/pie-chart/custom-transition-texture.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/echart/data/symbols.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/slick/slick-theme.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/jquery-jvectormap-2.0.2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-world-mill-en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-us-aea-en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-uk-mill-en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-au-mill.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-chicago-mill-en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-in-mill.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-asia-mill.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/dashboard/dashboard_3.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/datepicker/date-picker/datepicker.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datepicker/date-picker/datepicker.en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datepicker/date-picker/datepicker.custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/rating/jquery.barrating.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/rating/rating-script.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/owlcarousel/owl.carousel.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map-vector.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/countdown.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/ecommerce.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/handlebars.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/typeahead.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/typeahead.custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead-search/typeahead-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/height-equal.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/animation/wow/wow.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/apex-chart.js')); ?>"></script>
    <!-- Chart -->
    <script src="<?php echo e(asset('assets/js/chart/chartist/chartist.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/chartist/chartist-plugin-tooltip.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/chartist/chartist-custom.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- Chart End-->

    <!-- jQuery (required for DataTables) -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    <!-- DataTables Core JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>


    <script>
        new WOW().init();
    </script>

    <script>
        function animateNumber(selector, value) {
            $({ Counter: 0 }).animate({ Counter: value }, {
                duration: 2000,
                easing: 'swing',
                step: function (now) {
                    $(selector).text('Br ' + numberWithCommas(now.toFixed(2)));
                }
            });
        }

        // Format numbers with commas
        function numberWithCommas(x) {
            return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        function showToast(type, message) {
            toastr[type](message, type === 'error' ? 'Error' : 'Success', {
                closeButton: true,
                progressBar: true,
                timeOut: 3000
            });
        }

        // Render chart using ApexCharts
        function renderDailyChart(data) {
            var options = {
                series: [{
                    name: 'Amount',
                    data: data
                }],
                chart: {
                    type: 'area',
                    height: 250,
                    toolbar: { show: false }
                },
                stroke: {
                    curve: 'smooth',
                    width: 2
                },
                xaxis: {
                    categories: [...Array(24).keys()].map(h => `${h}:00`),
                    labels: { rotate: -45 }
                },
                yaxis: {
                    title: { text: 'Amount (Br)' }
                },
                dataLabels: { enabled: false },
                colors: ['#5c61f2'],
                fill: {
                    type: 'gradient',
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.6,
                        opacityTo: 0.05,
                        stops: [0, 90, 100]
                    }
                },
                tooltip: {
                    y: {
                        formatter: val => "Br " + val.toFixed(2)
                    }
                }
            };

            if (window.dailyChart) {
                window.dailyChart.destroy();
            }

            window.dailyChart = new ApexCharts(document.querySelector("#daily-transaction-chart"), options);
            window.dailyChart.render();
        }

        function loadDailyTransaction(date = 'today') {
            const container = $('#daily-transaction-body');
            const card = container.closest('.card');

            // Show spinner while loading
            container.html(`
                                                        <div class="d-flex justify-content-center align-items-center" style="min-height: 100px;">
                                                            <div class="spinner-border text-primary" role="status">
                                                                <span class="visually-hidden">Loading...</span>
                                                            </div>
                                                        </div>
                                                    `);

            // Add loading gradient to card
            card.addClass('card-loading-gradient');

            $.ajax({
                url: "<?php echo e(route('admin.financial.daily')); ?>", // single combined endpoint
                data: { date },
                success: function (res) {
                    const arrowIcon = res.isUp ? 'fa-arrow-up font-success' : 'fa-arrow-down font-danger';
                    const arrowBg = res.isUp ? 'up-arrow bg-light-success' : 'down-arrow bg-light-danger';
                    const colorClass = res.isUp ? 'font-success' : 'font-danger';
                    const prefix = res.isUp ? '+' : '';

                    const html = `
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="flex-shrink-0">
                                                                        <img src="<?php echo e(asset('assets/images/dashboard-3/icon/coin1.png')); ?>" alt="icon">
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <div class="d-flex align-items-center gap-2">
                                                                            <h5 id="daily-counter">Br 0.00</h5>
                                                                            <div class="d-flex total-icon">
                                                                                <p class="mb-0 ${arrowBg}">
                                                                                    <i class="fa ${arrowIcon}"></i>
                                                                                </p>
                                                                                <span class="f-w-500 ${colorClass}">
                                                                                    ${prefix}${res.percent}%
                                                                                </span>
                                                                            </div>
                                                                        </div>
                                                                        <p class="text-truncate">Compared to ${res.comparedTo}</p>
                                                                    </div>
                                                                </div>
                                                                <div id="daily-transaction-chart" style="height: 120px; margin-top: 15px;"></div>
                                                            `;

                    container.html(html);

                    animateNumber("#daily-counter", res.total);
                    renderDailyChart(res.chart);
                    showToast('success', 'Daily transaction updated');
                },
                error: function () {
                    container.html('<p class="text-danger text-center">Failed to load data.</p>');
                    showToast('error', 'Failed to load daily transaction data.');
                },
                complete: function () {
                    card.removeClass('card-loading-gradient');
                }
            });
        }

        $(document).ready(function () {
            loadDailyTransaction();

            // Reload on dropdown click
            $(document).on('click', '[data-date]', function (e) {
                e.preventDefault();
                const date = $(this).data('date');
                loadDailyTransaction(date);
            });
        });
    </script>




    <script>
        // Animate the number counter
        function animateNumber(selector, value) {
            $({ Counter: 0 }).animate({ Counter: value }, {
                duration: 2000,
                easing: 'swing',
                step: function (now) {
                    $(selector).text('Br ' + numberWithCommas(now.toFixed(2)));
                }
            });
        }

        // Format numbers with commas
        function numberWithCommas(x) {
            return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        // Setup Toastr (bottom-right fix)
        toastr.options = {
            "positionClass": "toast-bottom-right",
            "timeOut": "3000",
            "closeButton": true,
            "progressBar": true,
            "preventDuplicates": true
        };

        let weeklyChart; // Chart instance

        function renderWeeklyChart(data) {
            const options = {
                chart: {
                    type: 'line',
                    height: 250,
                    toolbar: { show: false },
                    animations: { enabled: true }
                },
                series: [{
                    name: 'Total Paid',
                    data: data
                }],
                xaxis: {
                    categories: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
                    title: { text: 'Day' }
                },
                yaxis: {
                    title: { text: 'Amount (Br)' }
                },
                stroke: {
                    curve: 'smooth',
                    width: 3
                },
                colors: ['#0d6efd'],
                tooltip: {
                    y: {
                        formatter: val => 'Br ' + numberWithCommas(val.toFixed(2))
                    }
                }
            };

            if (weeklyChart) {
                weeklyChart.updateOptions(options);
            } else {
                weeklyChart = new ApexCharts(document.querySelector("#weeklyChart"), options);
                weeklyChart.render();
            }
        }

        function loadWeeklyTransaction(range = 'this') {
            const container = $('#weekly-transaction-body');
            const topSection = container.find('.weekly-summary-top');
            const card = container.closest('.card');

            topSection.html(`
                                                    <div class="d-flex justify-content-center align-items-center" style="min-height: 100px;">
                                                        <div class="spinner-border text-primary" role="status">
                                                            <span class="visually-hidden">Loading...</span>
                                                        </div>
                                                    </div>
                                                `);

            card.addClass('card-loading-gradient');

            $.ajax({
                url: "<?php echo e(route('admin.financial.weekly')); ?>",
                data: { range },
                success: function (res) {
                    const arrowIcon = res.isUp ? 'fa-arrow-up font-success' : 'fa-arrow-down font-danger';
                    const arrowBg = res.isUp ? 'up-arrow bg-light-success' : 'down-arrow bg-light-danger';
                    const colorClass = res.isUp ? 'font-success' : 'font-danger';
                    const prefix = res.isUp ? '+' : '';

                    topSection.html(`
                                                            <div class="d-flex align-items-center gap-3">
                                                                <div class="flex-shrink-0">
                                                                    <img src="<?php echo e(asset('assets/images/dashboard-3/icon/shopping1.png')); ?>" alt="icon">
                                                                </div>
                                                                <div class="flex-grow-1">
                                                                    <div class="d-flex align-items-center gap-2">
                                                                        <h5 id="weekly-total-counter">Br 0.00</h5>
                                                                        <div class="d-flex total-icon">
                                                                            <p class="mb-0 ${arrowBg}">
                                                                                <i class="fa ${arrowIcon}"></i>
                                                                            </p>
                                                                            <span class="f-w-500 ${colorClass}">
                                                                                ${prefix}${res.percent}%
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                                    <p class="text-truncate">Compared to previous week</p>
                                                                </div>
                                                            </div>
                                                        `);

                    animateNumber("#weekly-total-counter", res.total);
                    renderWeeklyChart(res.chart);
                    toastr.success('Weekly transaction data loaded.');
                },
                error: function () {
                    topSection.html('<p class="text-danger text-center">Failed to load data.</p>');
                    toastr.error('Failed to load weekly transaction data.');
                },
                complete: function () {
                    card.removeClass('card-loading-gradient');
                }
            });
        }

        // Trigger initial load and week toggle
        $(document).ready(function () {
            loadWeeklyTransaction();

            $(document).on('click', '[data-week]', function (e) {
                e.preventDefault();
                const range = $(this).data('week');
                loadWeeklyTransaction(range);
            });
        });
    </script>


    <script>
        let monthlyChart; // For reusing ApexChart

        function renderMonthlyChart(data, labels) {
            const options = {
                chart: {
                    type: 'line',
                    height: 250,
                    toolbar: { show: false },
                    animations: { enabled: true }
                },
                series: [{
                    name: 'Total Paid',
                    data: data
                }],
                xaxis: {
                    categories: labels,
                    title: { text: 'Day of Month' },
                    labels: {
                        rotate: -45,
                        hideOverlappingLabels: true
                    }
                },
                yaxis: {
                    title: { text: 'Amount (Br)' }
                },
                stroke: {
                    curve: 'smooth',
                    width: 2
                },
                colors: ['#198754'],
                tooltip: {
                    y: {
                        formatter: val => 'Br ' + numberWithCommas(val.toFixed(2))
                    }
                },
                markers: {
                    size: 4
                }
            };

            if (monthlyChart) {
                monthlyChart.updateOptions(options);
            } else {
                monthlyChart = new ApexCharts(document.querySelector("#monthlyChart"), options);
                monthlyChart.render();
            }
        }

        function loadMonthlyTransaction(range = 'this') {
            const container = $('#monthly-transaction-body');
            const topSection = container.find('.monthly-summary-top');
            const card = $('#monthly-transaction-card');

            topSection.html(`
                                                        <div class="d-flex justify-content-center align-items-center" style="min-height: 100px;">
                                                            <div class="spinner-border text-primary" role="status">
                                                                <span class="visually-hidden">Loading...</span>
                                                            </div>
                                                        </div>
                                                    `);

            card.addClass('card-loading-gradient');

            $.ajax({
                url: "<?php echo e(route('admin.financial.monthly')); ?>",
                data: { range },
                success: function (res) {
                    const arrowIcon = res.isUp ? 'fa-arrow-up font-success' : 'fa-arrow-down font-danger';
                    const arrowBg = res.isUp ? 'up-arrow bg-light-success' : 'down-arrow bg-light-danger';
                    const colorClass = res.isUp ? 'font-success' : 'font-danger';
                    const prefix = res.isUp ? '+' : '';

                    topSection.html(`
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="flex-shrink-0">
                                                                        <img src="<?php echo e(asset('assets/images/dashboard-3/icon/sent1.png')); ?>" alt="icon">
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <div class="d-flex align-items-center gap-2">
                                                                            <h5 id="monthly-total-counter">Br 0.00</h5>
                                                                            <div class="d-flex total-icon">
                                                                                <p class="mb-0 ${arrowBg}">
                                                                                    <i class="fa ${arrowIcon}"></i>
                                                                                </p>
                                                                                <span class="f-w-500 ${colorClass}">
                                                                                    ${prefix}${res.percent}%
                                                                                </span>
                                                                            </div>
                                                                        </div>
                                                                        <p class="text-truncate">Compared to ${res.comparedTo}</p>
                                                                    </div>
                                                                </div>
                                                            `);

                    animateNumber("#monthly-total-counter", res.total);
                    renderMonthlyChart(res.chart, res.labels);
                    toastr.success('Monthly transaction data loaded.');
                },
                error: function () {
                    topSection.html('<p class="text-danger text-center">Failed to load data.</p>');
                    toastr.error('Failed to load monthly transaction data.');
                },
                complete: function () {
                    card.removeClass('card-loading-gradient');
                }
            });
        }

        $(document).ready(function () {
            loadMonthlyTransaction();

            $(document).on('click', '[data-month]', function (e) {
                e.preventDefault();
                const range = $(this).data('month');
                loadMonthlyTransaction(range);
            });
        });
    </script>


    <script>
        // Utility function to format numbers with commas
        function numberWithCommas(x) {
            return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        // Animate number count-up
        function animateNumber(selector, value) {
            $({ Counter: 0 }).animate({ Counter: value }, {
                duration: 2000,
                easing: 'swing',
                step: function (now) {
                    $(selector).text('Br ' + numberWithCommas(now.toFixed(2)));
                }
            });
        }

        // ApexCharts global variable
        let apexYearlyChart = null;

        // Render ApexCharts Yearly Revenue Line Chart
        function renderApexYearlyChart(data) {
            const options = {
                chart: {
                    type: 'line',
                    height: 250,
                    toolbar: { show: false },
                    animations: { enabled: true }
                },
                series: [{
                    name: 'Monthly Revenue',
                    data: data
                }],
                xaxis: {
                    categories: [
                        'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                        'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
                    ],
                    title: { text: 'Month' },
                    labels: {
                        rotate: -45,
                        hideOverlappingLabels: true
                    }
                },
                yaxis: {
                    title: { text: 'Amount (Br)' }
                },
                stroke: {
                    curve: 'smooth',
                    width: 2
                },
                colors: ['#36A2EB'],
                tooltip: {
                    y: {
                        formatter: val => 'Br ' + numberWithCommas(val.toFixed(2))
                    }
                },
                markers: {
                    size: 4
                }
            };

            // 💥 Always destroy and re-render (DOM gets replaced every time)
            if (apexYearlyChart) {
                apexYearlyChart.destroy();
            }

            apexYearlyChart = new ApexCharts(document.querySelector("#yearlyTransactionChart"), options);
            apexYearlyChart.render();
        }


        // Chart.js global variable
        let chartjsYearlyChart = null;

        // Render Chart.js Yearly Revenue Line Chart
        function renderChartjsYearlyChart(monthlyTotals, year) {
            const ctx = document.getElementById('yearlyLineChart').getContext('2d');

            if (chartjsYearlyChart) {
                chartjsYearlyChart.destroy();
            }

            chartjsYearlyChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                    datasets: [{
                        label: `Total Revenue for ${year}`,
                        data: monthlyTotals,
                        borderColor: '#4e73df',
                        backgroundColor: 'rgba(78, 115, 223, 0.1)',
                        fill: true,
                        tension: 0.3,
                        pointRadius: 4,
                        pointHoverRadius: 6
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { position: 'top' },
                        tooltip: {
                            callbacks: {
                                label: ctx => `Br ${ctx.parsed.y.toLocaleString()}`
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                callback: value => `Br ${value.toLocaleString()}`
                            }
                        }
                    }
                }
            });
        }

        // Load data and render ApexCharts chart
        function loadApexYearlyTransaction(range = 'this') {
            const container = $('.total-sells-4');
            const card = container.closest('.card');

            container.html(`
                                                <div class="d-flex justify-content-center align-items-center" style="min-height: 100px;">
                                                    <div class="spinner-border text-primary" role="status">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div>
                                                </div>
                                            `);

            card.addClass('card-loading-gradient');

            $.ajax({
                url: "<?php echo e(route('admin.financial.yearly')); ?>",
                data: { range },
                success: function (res) {
                    const arrowIcon = res.isUp ? 'fa-arrow-up font-success' : 'fa-arrow-down font-danger';
                    const arrowBg = res.isUp ? 'up-arrow bg-light-success' : 'down-arrow bg-light-danger';
                    const colorClass = res.isUp ? 'font-success' : 'font-danger';
                    const prefix = res.isUp ? '+' : '';

                    container.html(`
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="flex-shrink-0">
                                                                <img src="<?php echo e(asset('assets/images/dashboard-3/icon/revenue1.png')); ?>" alt="icon">
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <h5 id="yearly-total-counter">Br 0.00</h5>
                                                                    <div class="d-flex total-icon">
                                                                        <p class="mb-0 ${arrowBg}">
                                                                            <i class="fa ${arrowIcon}"></i>
                                                                        </p>
                                                                        <span class="f-w-500 ${colorClass}">
                                                                            ${prefix}${res.percent}%
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                                <p class="text-truncate">Compared to ${res.comparedTo}</p>
                                                            </div>
                                                        </div>
                                                        <div id="yearlyTransactionChart" class="mt-3" style="min-height: 250px;"></div>
                                                    `);

                    animateNumber("#yearly-total-counter", res.total);
                    renderApexYearlyChart(res.monthlyData);
                },
                error: function () {
                    container.html('<p class="text-danger text-center">Failed to load data.</p>');
                },
                complete: function () {
                    card.removeClass('card-loading-gradient');
                }
            });
        }


        // Load data and render Chart.js chart
        function loadChartjsYearlyChart(range = 'this') {
            $.ajax({
                url: "<?php echo e(route('admin.financial.monthly.breakdown')); ?>",
                data: { range },
                success: function (res) {
                    renderChartjsYearlyChart(res.monthlyTotals, res.year);
                    updateMonthlyModal(res.monthlyTotals, res.year);
                },
                error: function () {
                    toastr.error("Failed to load chart data.");
                }
            });
        }



        // Update monthly breakdown table (optional)
        function updateMonthlyModal(data, year) {
            const tbody = $('#monthlyBreakdownTable tbody');
            tbody.empty();
            const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
            months.forEach((month, i) => {
                tbody.append(`<tr>
                                                    <td>${month} ${year}</td>
                                                    <td>Br ${data[i].toLocaleString(undefined, { minimumFractionDigits: 2 })}</td>
                                                </tr>`);
            });
        }

        // Initialization on document ready
        $(document).ready(function () {
            loadApexYearlyTransaction();  // Load ApexCharts data & chart

            // Optionally load Chart.js chart if you want both charts
            loadChartjsYearlyChart();

            // Filters
            $(document).on('click', '[data-year]', function (e) {
                e.preventDefault();
                const range = $(this).data('year');
                loadApexYearlyTransaction(range);
            });

            $(document).on('click', '[data-chart-year]', function (e) {
                e.preventDefault();
                const range = $(this).data('chart-year');
                loadChartjsYearlyChart(range);
            });


        });





    </script>

    <script>
        $(document).ready(function () {
            $('#recentTransactionsTable').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 5, // show 5 per page
                ajax: "<?php echo e(route('admin.financial.recent-transactions')); ?>",
                columns: [
                    {
                        data: null,
                        orderable: false,
                        searchable: false,
                        render: function () {
                            return `
                            <div class="form-check">
                            <input class="form-check-input" type="checkbox">
                            </div>`;
                        }
                    },
                    {
                        data: 'student_name',
                        name: 'student_name',
                        render: function (data) {
                            return `<h6 class="mb-0">${data}</h6>`;
                        }
                    },
                    {
                        data: 'paid_at',
                        name: 'paid_at',
                        render: function (data) {
                            const date = new Date(data);
                            return date.toLocaleDateString() + ' - ' + date.toLocaleTimeString();
                        }
                    },
                    {
                        data: 'payment_method',
                        name: 'payment_method',
                        render: function (data) {
                            return `<span class="badge bg-warning text-dark">${data}</span>`;
                        }
                    },
                    {
                        data: 'amount',
                        name: 'amount',
                        render: function (data) {
                            return `<strong>${parseFloat(data).toLocaleString()} ETB</strong>`;
                        }
                    },
                    {
                        data: 'status',
                        name: 'status',
                        render: function (data) {
                            const color = data === 'success' ? 'success' : 'danger';
                            const label = data === 'success' ? 'Succeeded' : 'Failed';
                            return `<div class="badge  background-light-${color} font-${color} ">${label}</div>`;
                        }
                    }
                ]

            });
        });
    </script>

<script>
    function loadPaymentCount(period = 'today') {
        $('#payment-count-body .spinner-border').show();
        $('#paymentCountChart').hide();

        $.ajax({
            url: "<?php echo e(route('admin.financial.payment-count')); ?>",
            data: { period },
            success: function (response) {
                $('#payment-count-body .spinner-border').hide();
                $('#paymentCountChart').html(`
                    <div class="text-center">
                        <h2 class="text-primary">${response.count}</h2>
                        <p class="text-muted mb-0">${response.label}</p>
                    </div>
                `).fadeIn();
            },
            error: function () {
                $('#payment-count-body .spinner-border').hide();
                $('#paymentCountChart').html(`
                    <div class="text-center text-danger">Failed to load data.</div>
                `).fadeIn();
            }
        });
    }

    $(document).ready(function () {
        loadPaymentCount(); // default: today

        // handle dropdown clicks
        $('.dropdown-menu a[data-period]').on('click', function (e) {
            e.preventDefault();
            const period = $(this).data('period');
            loadPaymentCount(period);
        });
    });
</script>




<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Addisalem.Hailu Files\xampp\htdocs\costsharing\resources\views/admin/financial/summary.blade.php ENDPATH**/ ?>