<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Claim extends Model
{
    use SoftDeletes;

    protected $table = 'claims';

    protected $fillable = [
        'customer_id',
        'corporate_customer_id',
        'policy_id',
        'policy_number',
        'claim_number',
        'claim_type',
        'incident_date',
        'incident_location',
        'incident_description',
        'claim_amount_requested',
        'claim_amount_approved',
        'deductible',
        'settlement_amount',
        'claim_status',
        'submitted_at',
        'reviewed_at',
        'approved_at',
        'settled_at',
        'supporting_documents',
        'adjuster_notes',
        'assigned_adjuster',
        'created_by',
        'updated_by',
    ];



    protected $dates = [
        'incident_date',
        'submitted_at',
        'reviewed_at',
        'approved_at',
        'settled_at',
        'created_at',
        'updated_at',
        'deleted_at',
    ];



    /**
     * Relationships
     */

    // Claim belongs to a Customer (individual)
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    // Claim belongs to a Corporate Customer (optional)


    // Claim belongs to a Policy
    public function policy()
    {
        return $this->belongsTo(Policy::class);
    }

    // Claim documents (if normalized to a separate table)


    // Created by User relation
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    // Updated by User relation
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    /**
     * Accessors & Mutators
     */

    // Optionally cast supporting_documents from JSON string to array
    protected $casts = [
        'supporting_documents' => 'array',
    ];

    /**
     * Scopes for filtering by status or date range, if needed
     */

    public function scopePending($query)
    {
        return $query->where('claim_status', 'pending');
    }

    public function scopeApproved($query)
    {
        return $query->where('claim_status', 'approved');
    }

public function getStatusProgressAttribute()
{
    // Example: Map statuses to progress percentages
    $map = [
        'pending' => 20,
        'under_review' => 50,
        'approved' => 100,
        'rejected' => 0,
    ];

    return $map[strtolower($this->claim_status)] ?? 0;
}


    // Add more scopes as needed
}
