<?php

// app/Models/Policy.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Policy extends Model
{
    protected $fillable = [
        'policy_number', // ✅ ADD THIS
        'policy_type',
        'coverage_type',
        'policy_name',
        'description',
        'start_date',
        'end_date',
        'issue_date',
        'maturity_date',
        'renewal_date',
        'sum_assured',
        'premium_amount',
        'premium_frequency',
        'payment_method',
        'auto_renew',
        'status',
        'cancellation_reason',
        'number_of_beneficiaries',
        'attachments',
        'notes',
        'source',
        'customer_id',
        'created_by',
        'updated_by',
    ];


public function customer()
{
    return $this->belongsTo(Customer::class, 'customer_id');
}



public function claims()
{
    return $this->hasMany(Claim::class, 'policy_id');
}

}
