<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\BroadcastMessage;

class NewClaimNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $claim;

    public function __construct($claim)
    {
        $this->claim = $claim;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        return [
            'type' => 'claim',
            'title' => 'New Claim Submitted',
            'description' => 'Claim #' . $this->claim->claim_number . ' needs your attention.',
            'url' => route('claims.show', $this->claim->id),
            'icon' => 'file-text',
            'created_at' => now()->toDateTimeString(),
        ];
    }
}
