<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePolicyEndorsementsTable extends Migration
{
    public function up(): void
    {
        Schema::create('policy_endorsements', function (Blueprint $table) {
            $table->id();

            // Related to the original policy
            $table->unsignedBigInteger('policy_id');
            
            // Endorsement Details
            $table->string('endorsement_number')->unique(); // Unique reference number
            $table->date('effective_date'); // When the endorsement takes effect
            $table->string('endorsement_type'); // e.g., 'add_coverage', 'remove_coverage', 'change_beneficiary'
            $table->text('description')->nullable(); // Details of the change
            
            $table->decimal('additional_premium', 20, 2)->nullable(); // If endorsement changes the premium
            $table->decimal('refund_amount', 20, 2)->nullable(); // If endorsement reduces premium

            // Status
            $table->enum('status', ['pending', 'approved', 'rejected', 'cancelled'])->default('pending');
            $table->text('approval_notes')->nullable(); // Admin/underwriter notes

            // Tracking
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraints
            $table->foreign('policy_id')->references('id')->on('policies')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('policy_endorsements');
    }
}
