<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            // Primary Key
            $table->id(); // bigint(20) UNSIGNED equivalent
            
            // Personal Information
            $table->string('name', 100);
            $table->string('last_name', 100);
            $table->string('username', 50)->unique();
            $table->string('email', 100)->unique();
            $table->string('phone', 20)->nullable();
            $table->string('alt_phone', 20)->nullable();
            $table->enum('gender', ['male', 'female', 'other'])->nullable();
            $table->date('date_of_birth')->nullable();
            
            // Address Information
            $table->text('address')->nullable();
            $table->string('city', 100)->nullable();
            $table->string('state', 100)->nullable();
            $table->string('country', 100)->nullable();
            $table->string('postal_code', 20)->nullable();
            
            // Authentication
            $table->string('password');
            $table->string('remember_token', 100)->nullable();
            $table->boolean('otp_enabled')->default(0);
            
            // Verification & Tracking
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('phone_verified_at')->nullable();
            $table->timestamp('last_login_at')->nullable();
            $table->string('last_login_ip', 45)->nullable();
            
            // Profile
            $table->string('profile_picture', 255)->nullable();
            
            // Status
            $table->enum('status', ['active', 'inactive', 'banned'])->default('active');
            
            // Audit Fields
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');
            
            // Timestamps
            $table->timestamps(); // Creates created_at and updated_at
            $table->softDeletes(); // Creates deleted_at
            
            // Indexes
            $table->index('email');
            $table->index('phone');
        });

        // Set collation and engine explicitly if needed
        Schema::table('users', function (Blueprint $table) {
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('users');
    }
};