<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('fraud_analysis', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id'); // bigint(20) UNSIGNED NOT NULL

            // Foreign Key
            $table->foreignId('claim_id') // bigint(20) UNSIGNED NOT NULL
                  ->constrained()
                  ->onDelete('cascade');

            // Analysis Data
            $table->decimal('fraud_probability', 5, 2); // DECIMAL(5,2) NOT NULL
            $table->boolean('flagged')->default(false); // TINYINT(1) DEFAULT 0
            
            // Review Information
            $table->enum('review_status', [
                'pending',
                'verified',
                'fraud'
            ])->default('pending');
            
            $table->foreignId('reviewed_by') // bigint(20) UNSIGNED
                  ->nullable()
                  ->constrained('users')
                  ->onDelete('set null');

            // Timestamps
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrent()->useCurrentOnUpdate();
        });

        // Explicit database configuration
        Schema::table('fraud_analysis', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('fraud_analysis');
    }
};