<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('communication_logs', function (Blueprint $table) {
            // Primary Key
            $table->increments('id'); // int(11) NOT NULL

            // Foreign Key (Nullable)
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->onDelete('set null');

            // Communication Details
            $table->enum('channel', ['email', 'sms']);
            $table->string('recipient', 255);
            $table->text('message');
            $table->enum('status', ['sent', 'delivered', 'failed']);

            // Timestamp
            $table->timestamp('created_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('communication_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('communication_logs');
    }
};